/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.model;

import com.restoreit.model.ArenaRegion;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Arena {
    private final String name;
    private final String worldName;
    private final ArenaRegion region;
    private final LocalDateTime createdAt;
    private final String createdBy;
    private final Map<String, Object> metadata;
    private final Set<String> snapshots;

    private Arena(@NotNull String name, @NotNull String worldName, @NotNull ArenaRegion region, @NotNull LocalDateTime createdAt, @NotNull String createdBy, @NotNull Map<String, Object> metadata, @NotNull Set<String> snapshots) {
        this.name = name;
        this.worldName = worldName;
        this.region = region;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.metadata = Collections.unmodifiableMap(new HashMap<String, Object>(metadata));
        this.snapshots = Collections.unmodifiableSet(new HashSet<String>(snapshots));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public ArenaRegion getRegion() {
        return this.region;
    }

    @NotNull
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public String getCreatedBy() {
        return this.createdBy;
    }

    @NotNull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public Set<String> getSnapshots() {
        return this.snapshots;
    }

    public long getBlockCount() {
        return this.region.getVolume();
    }

    public int getSnapshotCount() {
        return this.snapshots.size();
    }

    public boolean hasSnapshots() {
        return !this.snapshots.isEmpty();
    }

    public boolean hasSnapshot(@NotNull String snapshotName) {
        return this.snapshots.contains(snapshotName);
    }

    @NotNull
    public static Builder builder(@NotNull String name) {
        return new Builder(name);
    }

    @NotNull
    public Arena withSnapshots(@NotNull Set<String> newSnapshots) {
        return new Arena(this.name, this.worldName, this.region, this.createdAt, this.createdBy, this.metadata, newSnapshots);
    }

    @NotNull
    public Arena withAddedSnapshot(@NotNull String snapshotName) {
        HashSet<String> newSnapshots = new HashSet<String>(this.snapshots);
        newSnapshots.add(snapshotName);
        return this.withSnapshots(newSnapshots);
    }

    @NotNull
    public Arena withRemovedSnapshot(@NotNull String snapshotName) {
        HashSet<String> newSnapshots = new HashSet<String>(this.snapshots);
        newSnapshots.remove(snapshotName);
        return this.withSnapshots(newSnapshots);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Arena arena = (Arena)obj;
        return Objects.equals(this.name, arena.name) && Objects.equals(this.worldName, arena.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.worldName);
    }

    @NotNull
    public String toString() {
        return "Arena{name='" + this.name + "', worldName='" + this.worldName + "', region=" + String.valueOf(this.region) + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy='" + this.createdBy + "', snapshots=" + this.snapshots.size() + "}";
    }

    public static final class Builder {
        private final String name;
        private String worldName;
        private ArenaRegion region;
        private LocalDateTime createdAt;
        private String createdBy;
        private final Map<String, Object> metadata = new HashMap<String, Object>();
        private final Set<String> snapshots = new HashSet<String>();

        private Builder(@NotNull String name) {
            this.name = name;
            this.createdAt = LocalDateTime.now();
        }

        @NotNull
        public Builder worldName(@NotNull String worldName) {
            this.worldName = worldName;
            return this;
        }

        @NotNull
        public Builder world(@NotNull World world) {
            this.worldName = world.getName();
            return this;
        }

        @NotNull
        public Builder region(@NotNull ArenaRegion region) {
            this.region = region;
            return this;
        }

        @NotNull
        public Builder createdAt(@NotNull LocalDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @NotNull
        public Builder createdBy(@NotNull String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @NotNull
        public Builder metadata(@NotNull String key, @Nullable Object value) {
            this.metadata.put(key, value);
            return this;
        }

        @NotNull
        public Builder metadata(@NotNull Map<String, Object> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        @NotNull
        public Builder addSnapshot(@NotNull String snapshotName) {
            this.snapshots.add(snapshotName);
            return this;
        }

        @NotNull
        public Builder addSnapshots(@NotNull Collection<String> snapshots) {
            this.snapshots.addAll(snapshots);
            return this;
        }

        @NotNull
        public Arena build() {
            if (this.worldName == null) {
                throw new IllegalStateException("World name is required");
            }
            if (this.region == null) {
                throw new IllegalStateException("Region is required");
            }
            if (this.createdBy == null) {
                throw new IllegalStateException("Creator is required");
            }
            return new Arena(this.name, this.worldName, this.region, this.createdAt, this.createdBy, this.metadata, this.snapshots);
        }
    }
}

