/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ArenaRegion {
    private final String worldName;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public ArenaRegion(@NotNull String worldName, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.worldName = worldName;
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getWidth() {
        return this.maxX - this.minX + 1;
    }

    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    public int getLength() {
        return this.maxZ - this.minZ + 1;
    }

    public long getVolume() {
        return (long)this.getWidth() * (long)this.getHeight() * (long)this.getLength();
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean overlaps(@NotNull ArenaRegion other) {
        if (!this.worldName.equals(other.worldName)) {
            return false;
        }
        return this.minX <= other.maxX && this.maxX >= other.minX && this.minY <= other.maxY && this.maxY >= other.minY && this.minZ <= other.maxZ && this.maxZ >= other.minZ;
    }

    @NotNull
    public String getCenterString() {
        int centerX = (this.minX + this.maxX) / 2;
        int centerY = (this.minY + this.maxY) / 2;
        int centerZ = (this.minZ + this.maxZ) / 2;
        return centerX + ", " + centerY + ", " + centerZ;
    }

    @NotNull
    public String getSizeString() {
        return this.getWidth() + "x" + this.getHeight() + "x" + this.getLength();
    }

    @NotNull
    public static ArenaRegion fromCorners(@NotNull String worldName, int x1, int y1, int z1, int x2, int y2, int z2) {
        return new ArenaRegion(worldName, x1, y1, z1, x2, y2, z2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArenaRegion that = (ArenaRegion)obj;
        return this.minX == that.minX && this.minY == that.minY && this.minZ == that.minZ && this.maxX == that.maxX && this.maxY == that.maxY && this.maxZ == that.maxZ && Objects.equals(this.worldName, that.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.worldName, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @NotNull
    public String toString() {
        return "ArenaRegion{world='" + this.worldName + "', min=(" + this.minX + "," + this.minY + "," + this.minZ + "), max=(" + this.maxX + "," + this.maxY + "," + this.maxZ + "), size=" + this.getSizeString() + ", volume=" + this.getVolume() + "}";
    }

    public boolean isWithinDistance(int x, int y, int z, int radius) {
        return this.getDistanceFrom(x, y, z) <= (double)radius;
    }

    public double getDistanceFrom(int x, int y, int z) {
        if (this.contains(x, y, z)) {
            return 0.0;
        }
        double dx = Math.max(0, Math.max(this.minX - x, x - this.maxX));
        double dy = Math.max(0, Math.max(this.minY - y, y - this.maxY));
        double dz = Math.max(0, Math.max(this.minZ - z, z - this.maxZ));
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

