/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.model;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Snapshot {
    private final String name;
    private final String arenaName;
    private final String worldName;
    private final LocalDateTime createdAt;
    private final String createdBy;
    private final String description;
    private final long blockCount;
    private final long fileSize;
    private final String fileName;
    private final Map<String, Object> metadata;
    private final SnapshotStatus status;

    private Snapshot(@NotNull String name, @NotNull String arenaName, @NotNull String worldName, @NotNull LocalDateTime createdAt, @NotNull String createdBy, @Nullable String description, long blockCount, long fileSize, @NotNull String fileName, @NotNull Map<String, Object> metadata, @NotNull SnapshotStatus status) {
        this.name = name;
        this.arenaName = arenaName;
        this.worldName = worldName;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.description = description;
        this.blockCount = blockCount;
        this.fileSize = fileSize;
        this.fileName = fileName;
        this.metadata = Collections.unmodifiableMap(new HashMap<String, Object>(metadata));
        this.status = status;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getArenaName() {
        return this.arenaName;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public SnapshotStatus getStatus() {
        return this.status;
    }

    @Nullable
    public Object getMetadata(@NotNull String key) {
        return this.metadata.get(key);
    }

    @NotNull
    public String getFormattedFileSize() {
        if (this.fileSize < 1024L) {
            return this.fileSize + " B";
        }
        if (this.fileSize < 0x100000L) {
            return String.format("%.1f KB", (double)this.fileSize / 1024.0);
        }
        if (this.fileSize < 0x40000000L) {
            return String.format("%.1f MB", (double)this.fileSize / 1048576.0);
        }
        return String.format("%.1f GB", (double)this.fileSize / 1.073741824E9);
    }

    @NotNull
    public String getFormattedBlockCount() {
        return String.format("%,d", this.blockCount);
    }

    public boolean isReady() {
        return this.status == SnapshotStatus.READY;
    }

    public boolean hasError() {
        return this.status == SnapshotStatus.ERROR || this.status == SnapshotStatus.CORRUPTED;
    }

    @NotNull
    public String getFullName() {
        return this.arenaName + ":" + this.name;
    }

    @NotNull
    public Snapshot withStatus(@NotNull SnapshotStatus newStatus) {
        return new Snapshot(this.name, this.arenaName, this.worldName, this.createdAt, this.createdBy, this.description, this.blockCount, this.fileSize, this.fileName, this.metadata, newStatus);
    }

    @NotNull
    public Snapshot withFileSize(long newFileSize) {
        return new Snapshot(this.name, this.arenaName, this.worldName, this.createdAt, this.createdBy, this.description, this.blockCount, newFileSize, this.fileName, this.metadata, this.status);
    }

    @NotNull
    public Snapshot withMetadata(@NotNull String key, @Nullable Object value) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>(this.metadata);
        if (value == null) {
            newMetadata.remove(key);
        } else {
            newMetadata.put(key, value);
        }
        return new Snapshot(this.name, this.arenaName, this.worldName, this.createdAt, this.createdBy, this.description, this.blockCount, this.fileSize, this.fileName, newMetadata, this.status);
    }

    @NotNull
    public static Builder builder(@NotNull String name, @NotNull String arenaName) {
        return new Builder(name, arenaName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Snapshot snapshot = (Snapshot)obj;
        return Objects.equals(this.name, snapshot.name) && Objects.equals(this.arenaName, snapshot.arenaName) && Objects.equals(this.worldName, snapshot.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arenaName, this.worldName);
    }

    @NotNull
    public String toString() {
        return "Snapshot{name='" + this.name + "', arena='" + this.arenaName + "', world='" + this.worldName + "', status=" + String.valueOf((Object)this.status) + ", blocks=" + this.getFormattedBlockCount() + ", size=" + this.getFormattedFileSize() + ", created=" + String.valueOf(this.createdAt) + "}";
    }

    public static enum SnapshotStatus {
        CREATING("Creating", "Snapshot is being created"),
        READY("Ready", "Snapshot is ready for use"),
        RESTORING("Restoring", "Snapshot is being restored"),
        ERROR("Error", "Snapshot has an error"),
        CORRUPTED("Corrupted", "Snapshot data is corrupted");

        private final String displayName;
        private final String description;

        private SnapshotStatus(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class Builder {
        private final String name;
        private final String arenaName;
        private String worldName;
        private LocalDateTime createdAt = LocalDateTime.now();
        private String createdBy = "Unknown";
        private String description;
        private long blockCount = 0L;
        private long fileSize = 0L;
        private String fileName;
        private final Map<String, Object> metadata = new HashMap<String, Object>();
        private SnapshotStatus status = SnapshotStatus.CREATING;

        private Builder(@NotNull String name, @NotNull String arenaName) {
            this.name = name;
            this.arenaName = arenaName;
            this.fileName = this.generateFileName(arenaName, name);
        }

        @NotNull
        public Builder worldName(@NotNull String worldName) {
            this.worldName = worldName;
            return this;
        }

        @NotNull
        public Builder createdAt(@NotNull LocalDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @NotNull
        public Builder createdBy(@NotNull String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @NotNull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder blockCount(long blockCount) {
            this.blockCount = blockCount;
            return this;
        }

        @NotNull
        public Builder fileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        @NotNull
        public Builder fileName(@NotNull String fileName) {
            this.fileName = fileName;
            return this;
        }

        @NotNull
        public Builder metadata(@NotNull String key, @Nullable Object value) {
            if (value == null) {
                this.metadata.remove(key);
            } else {
                this.metadata.put(key, value);
            }
            return this;
        }

        @NotNull
        public Builder status(@NotNull SnapshotStatus status) {
            this.status = status;
            return this;
        }

        @NotNull
        public Snapshot build() {
            if (this.worldName == null) {
                throw new IllegalStateException("World name is required");
            }
            return new Snapshot(this.name, this.arenaName, this.worldName, this.createdAt, this.createdBy, this.description, this.blockCount, this.fileSize, this.fileName, this.metadata, this.status);
        }

        @NotNull
        private String generateFileName(@NotNull String arenaName, @NotNull String snapshotName) {
            return arenaName.toLowerCase() + "_" + snapshotName.toLowerCase() + ".schem";
        }
    }
}

