/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DependencyContainer {
    private final Logger logger;
    private final Map<Class<?>, Object> dependencies;
    private boolean isShutdown = false;

    public DependencyContainer(@NotNull JavaPlugin plugin) {
        this.logger = plugin.getLogger();
        this.dependencies = new HashMap();
    }

    public <T> void register(@NotNull Class<T> clazz, @NotNull T instance) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        if (this.isShutdown) {
            throw new IllegalStateException("Container is shutdown");
        }
        if (this.dependencies.containsKey(clazz)) {
            this.logger.warning("Overriding existing dependency: " + clazz.getSimpleName());
        }
        this.dependencies.put(clazz, instance);
    }

    @Nullable
    public <T> T get(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (this.isShutdown) {
            throw new IllegalStateException("Container is shutdown");
        }
        Object dependency = this.dependencies.get(clazz);
        if (dependency == null) {
            return null;
        }
        try {
            return clazz.cast(dependency);
        }
        catch (ClassCastException e) {
            this.logger.severe("Failed to cast dependency " + clazz.getSimpleName() + ": " + e.getMessage());
            return null;
        }
    }

    @NotNull
    public <T> T getRequired(@NotNull Class<T> clazz) {
        T dependency = this.get(clazz);
        if (dependency == null) {
            throw new IllegalStateException("Required dependency not found: " + clazz.getSimpleName());
        }
        return dependency;
    }

    public boolean has(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (this.isShutdown) {
            return false;
        }
        return this.dependencies.containsKey(clazz);
    }

    @Nullable
    public <T> T unregister(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (this.isShutdown) {
            return null;
        }
        Object dependency = this.dependencies.remove(clazz);
        if (dependency != null) {
            return clazz.cast(dependency);
        }
        return null;
    }

    public int size() {
        return this.isShutdown ? 0 : this.dependencies.size();
    }

    public boolean isEmpty() {
        return this.isShutdown || this.dependencies.isEmpty();
    }

    @NotNull
    public Set<Class<?>> getRegisteredClasses() {
        return this.isShutdown ? Collections.emptySet() : Collections.unmodifiableSet(this.dependencies.keySet());
    }

    public void cleanup() {
        if (this.isShutdown) {
            return;
        }
        this.dependencies.values().forEach(dependency -> {
            if (dependency instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)dependency).close();
                }
                catch (Exception e) {
                    this.logger.warning("Failed to close dependency " + dependency.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        });
        this.dependencies.clear();
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @NotNull
    public String getDebugInfo() {
        if (this.isShutdown) {
            return "DependencyContainer [SHUTDOWN]";
        }
        StringBuilder info = new StringBuilder();
        info.append("DependencyContainer [").append(this.dependencies.size()).append(" dependencies]:\n");
        this.dependencies.keySet().forEach(clazz -> info.append("  - ").append(clazz.getSimpleName()).append("\n"));
        return info.toString();
    }
}

