/*
 * Decompiled with CFR 0.152.
 */
package com.restoreit.util;

import com.restoreit.config.ConfigManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class MessageManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final Logger logger;
    private final Map<String, FileConfiguration> languageConfigs;
    private final LegacyComponentSerializer legacySerializer;
    public static final String PREFIX = "prefix";
    public static final String NO_PERMISSION = "no-permission";
    public static final String COMMAND_USAGE = "command-usage";
    public static final String PLAYER_ONLY = "player-only";
    public static final String INVALID_ARGS = "invalid-args";
    public static final String OPERATION_SUCCESS = "operation-success";
    public static final String OPERATION_FAILED = "operation-failed";
    public static final String ARENA_CREATED = "arena.created";
    public static final String ARENA_DELETED = "arena.deleted";
    public static final String ARENA_NOT_FOUND = "arena.not-found";
    public static final String ARENA_ALREADY_EXISTS = "arena.already-exists";
    public static final String ARENA_LIST_HEADER = "arena.list-header";
    public static final String ARENA_LIST_ENTRY = "arena.list-entry";
    public static final String ARENA_INFO = "arena.info";
    public static final String SNAPSHOT_CREATED = "snapshot.created";
    public static final String SNAPSHOT_DELETED = "snapshot.deleted";
    public static final String SNAPSHOT_NOT_FOUND = "snapshot.not-found";
    public static final String SNAPSHOT_RESTORED = "snapshot.restored";
    public static final String SNAPSHOT_LIST_HEADER = "snapshot.list-header";
    public static final String SNAPSHOT_LIST_ENTRY = "snapshot.list-entry";
    public static final String ERROR_WORLDEDIT_REQUIRED = "error.worldedit-required";
    public static final String ERROR_NO_SELECTION = "error.no-selection";
    public static final String ERROR_INVALID_SELECTION = "error.invalid-selection";
    public static final String ERROR_ARENA_TOO_LARGE = "error.arena-too-large";
    public static final String ERROR_OPERATION_IN_PROGRESS = "error.operation-in-progress";

    public MessageManager(@NotNull JavaPlugin plugin, @NotNull ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.logger = plugin.getLogger();
        this.languageConfigs = new HashMap<String, FileConfiguration>();
        this.legacySerializer = LegacyComponentSerializer.legacySection();
        this.loadLanguages();
    }

    private void loadLanguages() {
        this.loadLanguage("en");
        String defaultLang = this.configManager.getDefaultLanguage();
        if (!"en".equals(defaultLang)) {
            this.loadLanguage(defaultLang);
        }
    }

    private void loadLanguage(@NotNull String language) {
        try {
            String resourcePath = "lang/" + language + ".yml";
            InputStream inputStream = this.plugin.getResource(resourcePath);
            if (inputStream != null) {
                YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                this.languageConfigs.put(language, (FileConfiguration)langConfig);
            } else {
                this.logger.warning("Language file not found: " + resourcePath);
                if ("en".equals(language)) {
                    this.createDefaultMessages();
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to load language " + language + ": " + e.getMessage());
        }
    }

    private void createDefaultMessages() {
        YamlConfiguration defaultConfig = new YamlConfiguration();
        defaultConfig.set(PREFIX, (Object)"\u00a78[\u00a7bRestoreIt\u00a78]\u00a7r ");
        defaultConfig.set(NO_PERMISSION, (Object)"\u00a7cYou don't have permission to do that!");
        defaultConfig.set(COMMAND_USAGE, (Object)"\u00a7cUsage: {0}");
        defaultConfig.set(PLAYER_ONLY, (Object)"\u00a7cThis command can only be used by players!");
        defaultConfig.set(INVALID_ARGS, (Object)"\u00a7cInvalid arguments. Use \u00a7e{0}\u00a7c for help.");
        defaultConfig.set(OPERATION_SUCCESS, (Object)"\u00a7aOperation completed successfully!");
        defaultConfig.set(OPERATION_FAILED, (Object)"\u00a7cOperation failed: {0}");
        defaultConfig.set(ARENA_CREATED, (Object)"\u00a7aArena '\u00a7e{0}\u00a7a' created successfully!");
        defaultConfig.set(ARENA_DELETED, (Object)"\u00a7aArena '\u00a7e{0}\u00a7a' deleted successfully!");
        defaultConfig.set(ARENA_NOT_FOUND, (Object)"\u00a7cArena '\u00a7e{0}\u00a7c' not found!");
        defaultConfig.set(ARENA_ALREADY_EXISTS, (Object)"\u00a7cArena '\u00a7e{0}\u00a7c' already exists!");
        defaultConfig.set(ARENA_LIST_HEADER, (Object)"\u00a76\u00a7lArenas ({0}):");
        defaultConfig.set(ARENA_LIST_ENTRY, (Object)"\u00a78- \u00a7e{0} \u00a77({1} blocks, {2} snapshots)");
        defaultConfig.set(ARENA_INFO, (Object)"\u00a76Arena Info: \u00a7e{0}\n\u00a77Size: \u00a7f{1} blocks\n\u00a77Snapshots: \u00a7f{2}\n\u00a77Created: \u00a7f{3}");
        defaultConfig.set(SNAPSHOT_CREATED, (Object)"\u00a7aSnapshot '\u00a7e{0}\u00a7a' created for arena '\u00a7e{1}\u00a7a'!");
        defaultConfig.set(SNAPSHOT_DELETED, (Object)"\u00a7aSnapshot '\u00a7e{0}\u00a7a' deleted successfully!");
        defaultConfig.set(SNAPSHOT_NOT_FOUND, (Object)"\u00a7cSnapshot '\u00a7e{0}\u00a7c' not found!");
        defaultConfig.set(SNAPSHOT_RESTORED, (Object)"\u00a7aArena '\u00a7e{0}\u00a7a' restored to snapshot '\u00a7e{1}\u00a7a'!");
        defaultConfig.set(SNAPSHOT_LIST_HEADER, (Object)"\u00a76\u00a7lSnapshots for arena '\u00a7e{0}\u00a76\u00a7l' ({1}):");
        defaultConfig.set(SNAPSHOT_LIST_ENTRY, (Object)"\u00a78- \u00a7e{0} \u00a77(created: {1})");
        defaultConfig.set(ERROR_WORLDEDIT_REQUIRED, (Object)"\u00a7cWorldEdit is required but not available!");
        defaultConfig.set(ERROR_NO_SELECTION, (Object)"\u00a7cYou need to make a WorldEdit selection first!");
        defaultConfig.set(ERROR_INVALID_SELECTION, (Object)"\u00a7cInvalid WorldEdit selection!");
        defaultConfig.set(ERROR_ARENA_TOO_LARGE, (Object)"\u00a7cArena is too large! Maximum size: {0} blocks");
        defaultConfig.set(ERROR_OPERATION_IN_PROGRESS, (Object)"\u00a7cAnother operation is already in progress for this arena!");
        this.languageConfigs.put("en", (FileConfiguration)defaultConfig);
    }

    @NotNull
    public String getRawMessage(@NotNull String key, Object ... args) {
        String language = this.configManager.getDefaultLanguage();
        FileConfiguration langConfig = this.languageConfigs.get(language);
        if (langConfig == null) {
            langConfig = this.languageConfigs.get("en");
        }
        if (langConfig == null) {
            this.logger.warning("No language configuration available for key: " + key);
            return key;
        }
        String message = langConfig.getString(key, key);
        if (args != null && args.length > 0) {
            try {
                message = MessageFormat.format(message, args);
            }
            catch (Exception e) {
                this.logger.warning("Failed to format message '" + key + "': " + e.getMessage());
            }
        }
        return message;
    }

    @NotNull
    public Component getMessage(@NotNull String key, Object ... args) {
        String rawMessage = this.getRawMessage(key, args);
        return this.legacySerializer.deserialize(rawMessage);
    }

    @NotNull
    public Component getPrefixedMessage(@NotNull String key, Object ... args) {
        TextComponent prefix = this.legacySerializer.deserialize(this.configManager.getMessagePrefix());
        Component message = this.getMessage(key, args);
        return prefix.append(message);
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull String key, Object ... args) {
        Component message = this.getPrefixedMessage(key, args);
        sender.sendMessage(message);
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull Component message) {
        sender.sendMessage(message);
    }

    public void sendSuccess(@NotNull CommandSender sender, @NotNull String message) {
        Component successMessage = this.legacySerializer.deserialize(message).color((TextColor)NamedTextColor.GREEN);
        this.sendMessage(sender, this.getPrefixedComponent().append(successMessage));
    }

    public void sendError(@NotNull CommandSender sender, @NotNull String message) {
        Component errorMessage = this.legacySerializer.deserialize(message).color((TextColor)NamedTextColor.RED);
        this.sendMessage(sender, this.getPrefixedComponent().append(errorMessage));
    }

    public void sendWarning(@NotNull CommandSender sender, @NotNull String message) {
        Component warningMessage = this.legacySerializer.deserialize(message).color((TextColor)NamedTextColor.YELLOW);
        this.sendMessage(sender, this.getPrefixedComponent().append(warningMessage));
    }

    public void sendInfo(@NotNull CommandSender sender, @NotNull String message) {
        Component infoMessage = this.legacySerializer.deserialize(message).color((TextColor)NamedTextColor.AQUA);
        this.sendMessage(sender, this.getPrefixedComponent().append(infoMessage));
    }

    @NotNull
    public Component getPrefixedComponent() {
        return this.legacySerializer.deserialize(this.configManager.getMessagePrefix());
    }

    @NotNull
    public String formatTimestamp(@NotNull LocalDateTime dateTime) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.configManager.getDateFormat());
            return dateTime.format(formatter);
        }
        catch (Exception e) {
            this.logger.warning("Failed to format timestamp: " + e.getMessage());
            return dateTime.toString();
        }
    }

    @NotNull
    public Component createClickableComponent(@NotNull String text, @NotNull String command, @NotNull String hoverText) {
        return ((TextComponent)((TextComponent)((TextComponent)Component.text((String)text).color((TextColor)NamedTextColor.YELLOW)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.runCommand((String)command))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)hoverText).color((TextColor)NamedTextColor.GRAY)));
    }

    public void reload() {
        this.languageConfigs.clear();
        this.loadLanguages();
    }
}

