package poeticrainbow.rainbowchristmas;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poeticrainbow.rainbowchristmas.registry.ModBlocks;
import poeticrainbow.rainbowchristmas.registry.ModItems;
import poeticrainbow.rainbowchristmas.registry.ModMisc;
import poeticrainbow.rainbowchristmas.render.MulticolorProvider;

public class RainbowChristmas implements ModInitializer, ClientModInitializer {
    public static String MOD_ID = "rainbowchristmas";
    public static Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    @Override
    public void onInitialize() {
        LOGGER.info("Time to get festive!");
        ModBlocks.onInitialize();
        ModItems.onInitialize();
        ModMisc.onInitialize();
    }

    @Override
    public void onInitializeClient() {
        LOGGER.info("Giving your client a little holiday spirit!");
        ColorProviderRegistry.ITEM.register(MulticolorProvider::rainbowItemColorProvider, ModBlocks.RAINBOW_HOLIDAY_LEAVES.method_8389());
        ColorProviderRegistry.BLOCK.register(MulticolorProvider::holidayLeavesBlockColorProvider, ModBlocks.RAINBOW_HOLIDAY_LEAVES);

        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.CHRISTMAS_TREE_STAND, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.FAUX_SNOW, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.MISTLETOE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.WREATH, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.STAR_TOPPER, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ICICLE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.NORTH_POLE, class_1921.method_23581());

        ModBlocks.ORNAMENTS.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
        ModBlocks.GARLANDS.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
        ModBlocks.CHRISTMAS_LIGHTS.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
        ModBlocks.HOLIDAY_LEAVES.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655(MOD_ID, name);
    }
}
