package poeticrainbow.rainbowchristmas.gen;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.minecraft.data.server.recipe.*;
import poeticrainbow.rainbowchristmas.RainbowChristmas;
import poeticrainbow.rainbowchristmas.registry.ModBlocks;
import poeticrainbow.rainbowchristmas.registry.ModItems;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class ModDataGenerator implements DataGeneratorEntrypoint {

    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();

        pack.addProvider(ModBlockTags::new);
        pack.addProvider(ModItemTags::new);
        pack.addProvider(ModRecipes::new);
        pack.addProvider(ModBlockLootTables::new);
        pack.addProvider(ModChestLootTables::new);
    }

    public static class ModBlockTags extends FabricTagProvider.BlockTagProvider {
        public static final class_6862<class_2248> PLANT_SUSTAINABLE = class_6862.method_40092(class_7924.field_41254, RainbowChristmas.id("plant_sustainable"));
        public static final class_6862<class_2248> GARLAND = class_6862.method_40092(class_7924.field_41254, RainbowChristmas.id("garland"));

        public ModBlockTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            method_10512(PLANT_SUSTAINABLE).add(ModBlocks.CHRISTMAS_TREE_STAND);
            method_10512(class_3481.field_38694).add(ModBlocks.CHRISTMAS_TREE_STAND);

            // Leaves
            FabricTagProvider<class_2248>.FabricTagBuilder leavesBuilder = method_10512(class_3481.field_15503);
            ModBlocks.HOLIDAY_LEAVES.forEach(leavesBuilder::add);

            // Garland
            FabricTagProvider<class_2248>.FabricTagBuilder garlandBuilder = method_10512(GARLAND);
            ModBlocks.GARLANDS.forEach(garlandBuilder::add);

            // Hoe Mineable
            FabricTagProvider<class_2248>.FabricTagBuilder hoeMineableBuilder = method_10512(class_3481.field_33714);
            ModBlocks.GARLANDS.forEach(hoeMineableBuilder::add);
            ModBlocks.HOLIDAY_LEAVES.forEach(hoeMineableBuilder::add);

            FabricTagProvider<class_2248>.FabricTagBuilder pickaxeMineableBuilder = method_10512(class_3481.field_33715);
            pickaxeMineableBuilder.add(ModBlocks.HARD_CANDY_BLOCK);
            pickaxeMineableBuilder.add(ModBlocks.HARD_CANDY_PILLAR);
            pickaxeMineableBuilder.add(ModBlocks.HARD_CANDY_TILES);
            pickaxeMineableBuilder.add(ModBlocks.HARD_CANDY_TILE_STAIRS);
            pickaxeMineableBuilder.add(ModBlocks.HARD_CANDY_TILE_SLAB);

            pickaxeMineableBuilder.add(ModBlocks.CANDY_CANE_PILLAR);
            pickaxeMineableBuilder.add(ModBlocks.CANDY_CANE_TILES);
            pickaxeMineableBuilder.add(ModBlocks.CANDY_CANE_TILE_STAIRS);
            pickaxeMineableBuilder.add(ModBlocks.CANDY_CANE_TILE_SLAB);
            pickaxeMineableBuilder.add(ModBlocks.NORTH_POLE);

            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BLOCK);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BLOCK_STAIRS);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BLOCK_SLAB);

            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BRICKS);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BRICK_STAIRS);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_BRICK_SLAB);

            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_SHINGLES);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_SHINGLE_STAIRS);
            pickaxeMineableBuilder.add(ModBlocks.GINGERBREAD_SHINGLE_SLAB);
        }
    }

    public static class ModItemTags extends FabricTagProvider.ItemTagProvider {
        public static final class_6862<class_1792> ORNAMENT = class_6862.method_40092(class_7924.field_41197, RainbowChristmas.id("ornament"));
        public static final class_6862<class_1792> GARLAND = class_6862.method_40092(class_7924.field_41197, RainbowChristmas.id("garland"));
        public static final class_6862<class_1792> ICE = class_6862.method_40092(class_7924.field_41197, RainbowChristmas.id("ice"));

        public ModItemTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            FabricTagBuilder ornamentBuilder = method_10512(ORNAMENT);
            ModBlocks.ORNAMENTS.forEach(block -> ornamentBuilder.add(block.method_8389()));

            FabricTagBuilder garlandBuilder = method_10512(GARLAND);
            ModBlocks.GARLANDS.forEach(block -> garlandBuilder.add(block.method_8389()));

            FabricTagProvider<class_1792>.FabricTagBuilder leavesBuilder = method_10512(class_3489.field_15558);
            ModBlocks.HOLIDAY_LEAVES.forEach(block -> leavesBuilder.add(block.method_8389()));

            FabricTagBuilder iceBuilder = method_10512(ICE);
            iceBuilder.add(class_1802.field_8426, class_1802.field_8081, class_1802.field_8178);
        }
    }

    public static class ModRecipes extends FabricRecipeProvider {

        public ModRecipes(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        public void offer2x2ConversionRecipe(class_8790 consumer, class_1935 output, class_1935 input) {
            class_2447.method_10436(class_7800.field_40634, output, 4)
                                   .method_10439("##")
                                   .method_10439("##")
                                   .method_10434('#', input)
                                   .method_10429(FabricRecipeProvider.method_32807(input), FabricRecipeProvider.method_10426(input))
                                   .method_10431(consumer);
        }

        @Override
        public void method_10419(class_8790 consumer) {
            class_2447.method_10437(class_7800.field_40635, ModBlocks.CLEAR_ORNAMENT)
                                   .method_10439("a")
                                   .method_10439("b")
                                   .method_10434('a', class_1802.field_8276)
                                   .method_10434('b', class_1802.field_8469)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8276), FabricRecipeProvider.method_10426(class_1802.field_8276))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8469), FabricRecipeProvider.method_10426(class_1802.field_8469))
                                   .method_10431(consumer);

            class_2447.method_10437(class_7800.field_40635, ModBlocks.WREATH)
                                   .method_10439("#X#")
                                   .method_10439("# #")
                                   .method_10439("###")
                                   .method_10433('#', class_3489.field_15558)
                                   .method_10434('X', class_1802.field_16998)
                                   .method_10429("has_leaves", FabricRecipeProvider.method_10420(class_3489.field_15558))
                                   .method_10431(consumer);

            class_2447.method_10437(class_7800.field_40635, ModBlocks.STAR_TOPPER)
                                   .method_10439("#X#")
                                   .method_10439("XXX")
                                   .method_10439("#$#")
                                   .method_10434('#', class_1802.field_8601)
                                   .method_10434('X', class_1802.field_8801)
                                   .method_10434('$', class_1802.field_8600)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8601), FabricRecipeProvider.method_10426(class_1802.field_8601))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8801), FabricRecipeProvider.method_10426(class_1802.field_8801))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8600), FabricRecipeProvider.method_10426(class_1802.field_8600))
                                   .method_10431(consumer);

            class_2447.method_10437(class_7800.field_40635, ModBlocks.MISTLETOE)
                                   .method_10439("$#$")
                                   .method_10439("#X#")
                                   .method_10439("%#%")
                                   .method_10433('#', class_3489.field_15558)
                                   .method_10433('X', ConventionalItemTags.DIAMOND_GEMS)
                                   .method_10434('$', class_1802.field_8276)
                                   .method_10434('%', class_1802.field_16998)
                                   .method_10429("has_leaves", FabricRecipeProvider.method_10420(class_3489.field_15558))
                                   .method_10429("has_diamonds", FabricRecipeProvider.method_10420(ConventionalItemTags.DIAMOND_GEMS))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8276), FabricRecipeProvider.method_10426(class_1802.field_8276))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_16998), FabricRecipeProvider.method_10426(class_1802.field_16998))
                                   .method_10431(consumer);

            class_2447.method_10437(class_7800.field_40642, ModBlocks.SHREDDER)
                                   .method_10439("#$#")
                                   .method_10439("#%#")
                                   .method_10439("#$#")
                                   .method_10433('#', class_3489.field_23802)
                                   .method_10434('$', class_1802.field_8725)
                                   .method_10434('%', class_1802.field_8868)
                                   .method_10429("has_cobble", FabricRecipeProvider.method_10420(class_3489.field_23802))
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8725), FabricRecipeProvider.method_10426(class_1802.field_8725))
                                   .method_10431(consumer);

            class_2447.method_10437(class_7800.field_40635, ModBlocks.CHRISTMAS_TREE_STAND)
                                   .method_10439("#$#")
                                   .method_10439("#%#")
                                   .method_10439("###")
                                   .method_10434('#', class_1802.field_8621)
                                   .method_10434('$', class_2246.field_10566)
                                   .method_10434('%', class_1802.field_8273)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8621), FabricRecipeProvider.method_10426(class_1802.field_8621))
                                   .method_10431(consumer);

            class_2447.method_10436(class_7800.field_40635, ModBlocks.ICICLE, 8)
                                   .method_10439("#")
                                   .method_10439("#")
                                   .method_10433('#', ModItemTags.ICE)
                                   .method_10429("has_ice", FabricRecipeProvider.method_10420(ModItemTags.ICE))
                                   .method_10431(consumer);

            class_2447.method_10436(class_7800.field_40640, ModItems.CANDY_CANE, 8)
                                   .method_10439("#$")
                                   .method_10439("X#")
                                   .method_10434('#', ModItems.HARD_CANDY)
                                   .method_10434('$', class_1802.field_8264)
                                   .method_10434('X', class_1802.field_8446)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8479), FabricRecipeProvider.method_10426(class_1802.field_8479))
                                   .method_10431(consumer);

            class_2447.method_10436(class_7800.field_40640, ModItems.CANDY_CANE, 8)
                                   .method_10439("#X")
                                   .method_10439("$#")
                                   .method_10434('#', ModItems.HARD_CANDY)
                                   .method_10434('$', class_1802.field_8264)
                                   .method_10434('X', class_1802.field_8446)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8479), FabricRecipeProvider.method_10426(class_1802.field_8479))
                                   .method_36443(consumer, "candy_cane_flipped");

            // Hard Candy
            class_2447.method_10437(class_7800.field_40634, ModBlocks.HARD_CANDY_BLOCK)
                                   .method_10439("##")
                                   .method_10439("##")
                                   .method_10434('#', ModItems.HARD_CANDY)
                                   .method_10429(FabricRecipeProvider.method_32807(ModItems.HARD_CANDY), FabricRecipeProvider.method_10426(ModItems.HARD_CANDY))
                                   .method_10431(consumer);
            class_2447.method_10436(class_7800.field_40634, ModBlocks.HARD_CANDY_TILES, 4)
                                   .method_10439("##")
                                   .method_10439("##")
                                   .method_10434('#', ModBlocks.HARD_CANDY_BLOCK)
                                   .method_10429(FabricRecipeProvider.method_32807(ModItems.HARD_CANDY), FabricRecipeProvider.method_10426(ModItems.HARD_CANDY))
                                   .method_10431(consumer);
            class_2446.method_32808(ModBlocks.HARD_CANDY_TILE_STAIRS, class_1856.method_8091(ModBlocks.HARD_CANDY_TILES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.HARD_CANDY_TILES), FabricRecipeProvider.method_10426(ModBlocks.HARD_CANDY_TILES))
                          .method_10431(consumer);
            class_2446.method_32804(class_7800.field_40634, ModBlocks.HARD_CANDY_TILE_SLAB, class_1856.method_8091(ModBlocks.HARD_CANDY_TILES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.HARD_CANDY_TILES), FabricRecipeProvider.method_10426(ModBlocks.HARD_CANDY_TILES))
                          .method_10431(consumer);
            class_2447.method_10436(class_7800.field_40634, ModBlocks.HARD_CANDY_PILLAR, 2)
                                   .method_10439("#")
                                   .method_10439("#")
                                   .method_10434('#', ModBlocks.HARD_CANDY_TILES)
                                   .method_10429(FabricRecipeProvider.method_32807(ModBlocks.HARD_CANDY_TILES), FabricRecipeProvider.method_10426(ModBlocks.HARD_CANDY_TILES))
                                   .method_10431(consumer);

            // Candy Cane
            class_2446.method_46209(consumer, class_7800.field_40634, ModBlocks.CANDY_CANE_TILES, ModItems.CANDY_CANE);
            class_2446.method_32808(ModBlocks.CANDY_CANE_TILE_STAIRS, class_1856.method_8091(ModBlocks.CANDY_CANE_TILES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.CANDY_CANE_TILES), FabricRecipeProvider.method_10426(ModBlocks.CANDY_CANE_TILES))
                          .method_10431(consumer);
            class_2446.method_32804(class_7800.field_40634, ModBlocks.CANDY_CANE_TILE_SLAB, class_1856.method_8091(ModBlocks.CANDY_CANE_TILES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.CANDY_CANE_TILES), FabricRecipeProvider.method_10426(ModBlocks.CANDY_CANE_TILES))
                          .method_10431(consumer);
            class_2447.method_10436(class_7800.field_40634, ModBlocks.CANDY_CANE_PILLAR, 2)
                                   .method_10439("#")
                                   .method_10439("#")
                                   .method_10434('#', ModBlocks.CANDY_CANE_TILES)
                                   .method_10429(FabricRecipeProvider.method_32807(ModBlocks.CANDY_CANE_TILES), FabricRecipeProvider.method_10426(ModBlocks.CANDY_CANE_TILES))
                                   .method_10431(consumer);

            class_2446.method_33531(class_7800.field_40634, ModBlocks.NORTH_POLE, class_1856.method_8091(ModBlocks.CANDY_CANE_TILES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.CANDY_CANE_TILES), FabricRecipeProvider.method_10426(ModBlocks.CANDY_CANE_TILES))
                          .method_10431(consumer);

            // Gingerbread
            class_2446.method_46209(consumer, class_7800.field_40634, ModBlocks.GINGERBREAD_BLOCK, ModItems.GINGERBREAD_COOKIE);
            class_2446.method_32808(ModBlocks.GINGERBREAD_BLOCK_STAIRS, class_1856.method_8091(ModBlocks.GINGERBREAD_BLOCK))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_BLOCK), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_BLOCK))
                          .method_10431(consumer);
            class_2446.method_32804(class_7800.field_40634, ModBlocks.GINGERBREAD_BLOCK_SLAB, class_1856.method_8091(ModBlocks.GINGERBREAD_BLOCK))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_BLOCK), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_BLOCK))
                          .method_10431(consumer);

            offer2x2ConversionRecipe(consumer, ModBlocks.GINGERBREAD_BRICKS, ModBlocks.GINGERBREAD_BLOCK);
            class_2446.method_32808(ModBlocks.GINGERBREAD_BRICK_STAIRS, class_1856.method_8091(ModBlocks.GINGERBREAD_BRICKS))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_BRICKS), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_BRICKS))
                          .method_10431(consumer);
            class_2446.method_32804(class_7800.field_40634, ModBlocks.GINGERBREAD_BRICK_SLAB, class_1856.method_8091(ModBlocks.GINGERBREAD_BRICKS))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_BRICKS), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_BRICKS))
                          .method_10431(consumer);


            offer2x2ConversionRecipe(consumer, ModBlocks.GINGERBREAD_SHINGLES, ModBlocks.GINGERBREAD_BRICKS);
            class_2446.method_32808(ModBlocks.GINGERBREAD_SHINGLE_STAIRS, class_1856.method_8091(ModBlocks.GINGERBREAD_SHINGLES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_SHINGLES), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_SHINGLES))
                          .method_10431(consumer);
            class_2446.method_32804(class_7800.field_40634, ModBlocks.GINGERBREAD_SHINGLE_SLAB, class_1856.method_8091(ModBlocks.GINGERBREAD_SHINGLES))
                          .method_33530(FabricRecipeProvider.method_32807(ModBlocks.GINGERBREAD_SHINGLES), FabricRecipeProvider.method_10426(ModBlocks.GINGERBREAD_SHINGLES))
                          .method_10431(consumer);

            // Hard Candy Item
            class_2454.method_17802(class_1856.method_8091(class_1802.field_8479), class_7800.field_40640, ModItems.HARD_CANDY, 0f, 200)
                                    .method_10469(FabricRecipeProvider.method_32807(class_1802.field_8479), FabricRecipeProvider.method_10426(class_1802.field_8479))
                                    .method_10431(consumer);
            class_2454.method_35918(class_1856.method_8091(class_1802.field_8479), class_7800.field_40640, ModItems.HARD_CANDY, 0f, 100)
                                    .method_10469(FabricRecipeProvider.method_32807(class_1802.field_8479), FabricRecipeProvider.method_10426(class_1802.field_8479))
                                    .method_36443(consumer, "hard_candy_smoking");

            class_2447.method_10436(class_7800.field_40640, ModItems.GINGERBREAD_COOKIE, 8)
                                   .method_10439(" # ")
                                   .method_10439("$%$")
                                   .method_10434('#', ModItems.WARM_SPICES)
                                   .method_10434('$', class_1802.field_8861)
                                   .method_10434('%', class_1802.field_8479)
                                   .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8479), FabricRecipeProvider.method_10426(class_1802.field_8479))
                                   .method_10431(consumer);

            class_2450.method_10447(class_7800.field_40640, ModItems.CHOCOLATE_MILK_BUCKET)
                                      .method_10454(class_1802.field_8116)
                                      .method_10454(class_1802.field_8103)
                                      .method_10454(class_1802.field_8479)
                                      .method_10442(FabricRecipeProvider.method_32807(class_1802.field_8103), FabricRecipeProvider.method_10426(class_1802.field_8103))
                                      .method_10431(consumer);

            class_2454.method_17802(class_1856.method_8091(ModItems.CHOCOLATE_MILK_BUCKET), class_7800.field_40640, ModItems.HOT_CHOCOLATE_BUCKET, 0f, 200)
                                    .method_10469(FabricRecipeProvider.method_32807(ModItems.CHOCOLATE_MILK_BUCKET), FabricRecipeProvider.method_10426(ModItems.CHOCOLATE_MILK_BUCKET))
                                    .method_10431(consumer);
            class_2454.method_35918(class_1856.method_8091(ModItems.CHOCOLATE_MILK_BUCKET), class_7800.field_40640, ModItems.HOT_CHOCOLATE_BUCKET, 0f, 100)
                                    .method_10469(FabricRecipeProvider.method_32807(ModItems.CHOCOLATE_MILK_BUCKET), FabricRecipeProvider.method_10426(ModItems.CHOCOLATE_MILK_BUCKET))
                                    .method_36443(consumer, "hot_chocolate_bucket_smoking");

            createFestiveHatRecipe(ModItems.WHITE_FESTIVE_HAT.method_8389(), class_1802.field_8446).method_10431(consumer);
            createFestiveHatRecipe(ModItems.LIGHT_GRAY_FESTIVE_HAT.method_8389(), class_1802.field_8851).method_10431(consumer);
            createFestiveHatRecipe(ModItems.GRAY_FESTIVE_HAT.method_8389(), class_1802.field_8298).method_10431(consumer);
            createFestiveHatRecipe(ModItems.BLACK_FESTIVE_HAT.method_8389(), class_1802.field_8226).method_10431(consumer);
            createFestiveHatRecipe(ModItems.BROWN_FESTIVE_HAT.method_8389(), class_1802.field_8099).method_10431(consumer);
            createFestiveHatRecipe(ModItems.RED_FESTIVE_HAT.method_8389(), class_1802.field_8264).method_10431(consumer);
            createFestiveHatRecipe(ModItems.ORANGE_FESTIVE_HAT.method_8389(), class_1802.field_8492).method_10431(consumer);
            createFestiveHatRecipe(ModItems.YELLOW_FESTIVE_HAT.method_8389(), class_1802.field_8192).method_10431(consumer);
            createFestiveHatRecipe(ModItems.LIME_FESTIVE_HAT.method_8389(), class_1802.field_8131).method_10431(consumer);
            createFestiveHatRecipe(ModItems.GREEN_FESTIVE_HAT.method_8389(), class_1802.field_8408).method_10431(consumer);
            createFestiveHatRecipe(ModItems.CYAN_FESTIVE_HAT.method_8389(), class_1802.field_8632).method_10431(consumer);
            createFestiveHatRecipe(ModItems.LIGHT_BLUE_FESTIVE_HAT.method_8389(), class_1802.field_8273).method_10431(consumer);
            createFestiveHatRecipe(ModItems.BLUE_FESTIVE_HAT.method_8389(), class_1802.field_8345).method_10431(consumer);
            createFestiveHatRecipe(ModItems.PURPLE_FESTIVE_HAT.method_8389(), class_1802.field_8296).method_10431(consumer);
            createFestiveHatRecipe(ModItems.MAGENTA_FESTIVE_HAT.method_8389(), class_1802.field_8669).method_10431(consumer);
            createFestiveHatRecipe(ModItems.PINK_FESTIVE_HAT.method_8389(), class_1802.field_8330).method_10431(consumer);

            createDyedOrnamentRecipe(ModBlocks.WHITE_ORNAMENT.method_8389(), class_1802.field_8446).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.LIGHT_GRAY_ORNAMENT.method_8389(), class_1802.field_8851).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.GRAY_ORNAMENT.method_8389(), class_1802.field_8298).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.BLACK_ORNAMENT.method_8389(), class_1802.field_8226).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.BROWN_ORNAMENT.method_8389(), class_1802.field_8099).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.RED_ORNAMENT.method_8389(), class_1802.field_8264).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.ORANGE_ORNAMENT.method_8389(), class_1802.field_8492).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.YELLOW_ORNAMENT.method_8389(), class_1802.field_8192).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.LIME_ORNAMENT.method_8389(), class_1802.field_8131).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.GREEN_ORNAMENT.method_8389(), class_1802.field_8408).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.CYAN_ORNAMENT.method_8389(), class_1802.field_8632).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.LIGHT_BLUE_ORNAMENT.method_8389(), class_1802.field_8273).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.BLUE_ORNAMENT.method_8389(), class_1802.field_8345).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.PURPLE_ORNAMENT.method_8389(), class_1802.field_8296).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.MAGENTA_ORNAMENT.method_8389(), class_1802.field_8669).method_10431(consumer);
            createDyedOrnamentRecipe(ModBlocks.PINK_ORNAMENT.method_8389(), class_1802.field_8330).method_10431(consumer);

            createDyedGarlandRecipe(ModBlocks.WHITE_GARLAND.method_8389(), class_1802.field_8446).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.LIGHT_GRAY_GARLAND.method_8389(), class_1802.field_8851).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.GRAY_GARLAND.method_8389(), class_1802.field_8298).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.BLACK_GARLAND.method_8389(), class_1802.field_8226).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.BROWN_GARLAND.method_8389(), class_1802.field_8099).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.RED_GARLAND.method_8389(), class_1802.field_8264).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.ORANGE_GARLAND.method_8389(), class_1802.field_8492).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.YELLOW_GARLAND.method_8389(), class_1802.field_8192).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.LIME_GARLAND.method_8389(), class_1802.field_8131).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.GREEN_GARLAND.method_8389(), class_1802.field_8408).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.CYAN_GARLAND.method_8389(), class_1802.field_8632).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.LIGHT_BLUE_GARLAND.method_8389(), class_1802.field_8273).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.BLUE_GARLAND.method_8389(), class_1802.field_8345).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.PURPLE_GARLAND.method_8389(), class_1802.field_8296).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.MAGENTA_GARLAND.method_8389(), class_1802.field_8669).method_10431(consumer);
            createDyedGarlandRecipe(ModBlocks.PINK_GARLAND.method_8389(), class_1802.field_8330).method_10431(consumer);

            createGarlandFromHolidayLeavesRecipe(ModBlocks.WHITE_GARLAND.method_8389(), ModBlocks.WHITE_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "white_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.LIGHT_GRAY_GARLAND.method_8389(), ModBlocks.LIGHT_GRAY_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "light_gray_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.GRAY_GARLAND.method_8389(), ModBlocks.GRAY_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "gray_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.BLACK_GARLAND.method_8389(), ModBlocks.BLACK_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "black_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.BROWN_GARLAND.method_8389(), ModBlocks.BROWN_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "brown_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.RED_GARLAND.method_8389(), ModBlocks.RED_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "red_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.ORANGE_GARLAND.method_8389(), ModBlocks.ORANGE_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "orange_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.YELLOW_GARLAND.method_8389(), ModBlocks.YELLOW_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "yellow_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.LIME_GARLAND.method_8389(), ModBlocks.LIME_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "lime_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.GREEN_GARLAND.method_8389(), ModBlocks.GREEN_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "green_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.CYAN_GARLAND.method_8389(), ModBlocks.CYAN_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "cyan_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.LIGHT_BLUE_GARLAND.method_8389(), ModBlocks.LIGHT_BLUE_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "light_blue_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.BLUE_GARLAND.method_8389(), ModBlocks.BLUE_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "blue_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.PURPLE_GARLAND.method_8389(), ModBlocks.PURPLE_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "purple_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.MAGENTA_GARLAND.method_8389(), ModBlocks.MAGENTA_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "magenta_garland_from_holiday_leaves");
            createGarlandFromHolidayLeavesRecipe(ModBlocks.PINK_GARLAND.method_8389(), ModBlocks.PINK_HOLIDAY_LEAVES.method_8389()).method_36443(consumer, "pink_garland_from_holiday_leaves");

            createDyedHolidayLeavesRecipe(ModBlocks.RAINBOW_HOLIDAY_LEAVES.method_8389(), class_1802.field_27063).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.WHITE_HOLIDAY_LEAVES.method_8389(), class_1802.field_8446).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.LIGHT_GRAY_HOLIDAY_LEAVES.method_8389(), class_1802.field_8851).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.GRAY_HOLIDAY_LEAVES.method_8389(), class_1802.field_8298).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.BLACK_HOLIDAY_LEAVES.method_8389(), class_1802.field_8226).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.BROWN_HOLIDAY_LEAVES.method_8389(), class_1802.field_8099).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.RED_HOLIDAY_LEAVES.method_8389(), class_1802.field_8264).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.ORANGE_HOLIDAY_LEAVES.method_8389(), class_1802.field_8492).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.YELLOW_HOLIDAY_LEAVES.method_8389(), class_1802.field_8192).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.LIME_HOLIDAY_LEAVES.method_8389(), class_1802.field_8131).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.GREEN_HOLIDAY_LEAVES.method_8389(), class_1802.field_8408).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.CYAN_HOLIDAY_LEAVES.method_8389(), class_1802.field_8632).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.LIGHT_BLUE_HOLIDAY_LEAVES.method_8389(), class_1802.field_8273).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.BLUE_HOLIDAY_LEAVES.method_8389(), class_1802.field_8345).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.PURPLE_HOLIDAY_LEAVES.method_8389(), class_1802.field_8296).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.MAGENTA_HOLIDAY_LEAVES.method_8389(), class_1802.field_8669).method_10431(consumer);
            createDyedHolidayLeavesRecipe(ModBlocks.PINK_HOLIDAY_LEAVES.method_8389(), class_1802.field_8330).method_10431(consumer);

            createChristmasLightsRecipe(ModBlocks.MULTICOLOR_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_27063).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.WHITE_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8446).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.LIGHT_GRAY_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8851).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.GRAY_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8298).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.BLACK_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8226).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.BROWN_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8099).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.RED_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8264).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.ORANGE_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8492).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.YELLOW_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8192).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.LIME_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8131).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.GREEN_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8408).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.CYAN_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8632).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.LIGHT_BLUE_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8273).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.BLUE_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8345).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.PURPLE_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8296).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.MAGENTA_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8669).method_10431(consumer);
            createChristmasLightsRecipe(ModBlocks.PINK_CHRISTMAS_LIGHTS.method_8389(), class_1802.field_8330).method_10431(consumer);
        }

        public class_2447 createFestiveHatRecipe(class_1792 hat, class_1792 dye) {
            return class_2447.method_10437(class_7800.field_40639, hat)
                                          .method_10439("###")
                                          .method_10439("#$#")
                                          .method_10433('#', class_3489.field_15544)
                                          .method_10434('$', dye)
                                          .method_10435("festive_hat")
                                          .method_10429("has_wool", FabricRecipeProvider.method_10420(class_3489.field_15544))
                                          .method_10429(FabricRecipeProvider.method_32807(dye), FabricRecipeProvider.method_10426(dye));
        }

        public class_2447 createDyedOrnamentRecipe(class_1792 ornament, class_1792 dye) {
            return class_2447.method_10436(class_7800.field_40635, ornament, 4)
                                          .method_10439(" # ")
                                          .method_10439("#X#")
                                          .method_10439(" # ")
                                          .method_10433('#', ModItemTags.ORNAMENT)
                                          .method_10434('X', dye)
                                          .method_10435("ornament")
                                          .method_10429(FabricRecipeProvider.method_32807(ModBlocks.CLEAR_ORNAMENT), FabricRecipeProvider.method_10426(ModBlocks.CLEAR_ORNAMENT));
        }

        public class_2447 createDyedGarlandRecipe(class_1792 garland, class_1792 dye) {
            return class_2447.method_10436(class_7800.field_40635, garland, 6)
                                          .method_10439("$X$")
                                          .method_10439("###")
                                          .method_10433('#', class_3489.field_15558)
                                          .method_10434('$', class_1802.field_8276)
                                          .method_10434('X', dye)
                                          .method_10435("garland")
                                          .method_10429("has_leaves", FabricRecipeProvider.method_10420(class_3489.field_15558));
        }

        public class_2447 createGarlandFromHolidayLeavesRecipe(class_1792 garland, class_1792 holidayLeaves) {
            return class_2447.method_10436(class_7800.field_40635, garland, 6)
                                          .method_10439("$ $")
                                          .method_10439("###")
                                          .method_10434('#', holidayLeaves)
                                          .method_10434('$', class_1802.field_8276)
                                          .method_10435("garland_from_holiday_leaves")
                                          .method_10429(FabricRecipeProvider.method_32807(holidayLeaves), FabricRecipeProvider.method_10426(holidayLeaves));
        }

        public class_2447 createDyedHolidayLeavesRecipe(class_1792 leaves, class_1792 dye) {
            return class_2447.method_10436(class_7800.field_40635, leaves, 8)
                                          .method_10439("###")
                                          .method_10439("#X#")
                                          .method_10439("###")
                                          .method_10433('#', class_3489.field_15558)
                                          .method_10434('X', dye)
                                          .method_10435("holiday_leaves")
                                          .method_10429("has_leaves", FabricRecipeProvider.method_10420(class_3489.field_15558));
        }

        public class_2447 createChristmasLightsRecipe(class_1792 lights, class_1792 dye) {
            return class_2447.method_10436(class_7800.field_40635, lights, 6)
                                          .method_10439("$X$")
                                          .method_10439("###")
                                          .method_10434('#', class_1802.field_8469)
                                          .method_10434('X', dye)
                                          .method_10434('$', class_1802.field_8276)
                                          .method_10435("christmas_lights")
                                          .method_10429(FabricRecipeProvider.method_32807(dye), FabricRecipeProvider.method_10426(dye))
                                          .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8276), FabricRecipeProvider.method_10426(class_1802.field_8276))
                                          .method_10429(FabricRecipeProvider.method_32807(class_1802.field_8469), FabricRecipeProvider.method_10426(class_1802.field_8469));
        }
    }

    public static class ModBlockLootTables extends FabricBlockLootTableProvider {
        protected ModBlockLootTables(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void method_10379() {
            method_46025(ModBlocks.CHRISTMAS_TREE_STAND);
            method_46025(ModBlocks.MISTLETOE);
            method_46025(ModBlocks.WREATH);
            method_46025(ModBlocks.FAUX_SNOW);
            method_46025(ModBlocks.STAR_TOPPER);
            method_46025(ModBlocks.ICICLE);
            method_46025(ModBlocks.SHREDDER);

            method_46025(ModBlocks.HARD_CANDY_BLOCK);
            method_46025(ModBlocks.HARD_CANDY_TILES);
            method_45988(ModBlocks.HARD_CANDY_TILE_SLAB, method_45980(ModBlocks.HARD_CANDY_TILE_SLAB));
            method_46025(ModBlocks.HARD_CANDY_TILE_STAIRS);
            method_46025(ModBlocks.HARD_CANDY_PILLAR);

            method_46025(ModBlocks.CANDY_CANE_TILES);
            method_45988(ModBlocks.CANDY_CANE_TILE_SLAB, method_45980(ModBlocks.CANDY_CANE_TILE_SLAB));
            method_46025(ModBlocks.CANDY_CANE_TILE_STAIRS);
            method_46025(ModBlocks.CANDY_CANE_PILLAR);
            method_46025(ModBlocks.NORTH_POLE);

            method_46025(ModBlocks.GINGERBREAD_BLOCK);
            method_45988(ModBlocks.GINGERBREAD_BLOCK_SLAB, method_45980(ModBlocks.GINGERBREAD_BLOCK_SLAB));
            method_46025(ModBlocks.GINGERBREAD_BLOCK_STAIRS);
            method_46025(ModBlocks.GINGERBREAD_BRICKS);
            method_45988(ModBlocks.GINGERBREAD_BRICK_SLAB, method_45980(ModBlocks.GINGERBREAD_BRICK_SLAB));
            method_46025(ModBlocks.GINGERBREAD_BRICK_STAIRS);
            method_46025(ModBlocks.GINGERBREAD_SHINGLES);
            method_45988(ModBlocks.GINGERBREAD_SHINGLE_SLAB, method_45980(ModBlocks.GINGERBREAD_SHINGLE_SLAB));
            method_46025(ModBlocks.GINGERBREAD_SHINGLE_STAIRS);


            ModBlocks.ORNAMENTS.forEach(this::method_46025);
            ModBlocks.GARLANDS.forEach(this::method_46025);
            ModBlocks.CHRISTMAS_LIGHTS.forEach(this::method_46025);
            ModBlocks.HOLIDAY_LEAVES.forEach(this::method_46025);
        }
    }

    public static class ModChestLootTables extends SimpleFabricLootTableProvider {
        public ModChestLootTables(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1179);
        }


        public class_5321<class_52> key(String path) {
            return class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(RainbowChristmas.MOD_ID, path));
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> exporter) {
            exporter.accept(key("gingerbread_house"), class_52.method_324()
                                                               .method_336(class_55.method_347()
                                                                             .method_352(class_44.method_32448(24.0f))
                                                                             .method_351(class_77.method_411(ModItems.WARM_SPICES))
                                                                             .method_351(class_77.method_411(ModItems.CANDY_CANE))
                                                                             .method_351(class_77.method_411(ModItems.GINGERBREAD_COOKIE))));
            exporter.accept(key("gingerbread_house_festive_hat_materials"), class_52.method_324()
                                                                                     .method_336(class_55.method_347()
                                                                                                   .method_352(class_44.method_32448(15.0f))
                                                                                                   .method_351(class_77.method_411(class_1802.field_19044)
                                                                                                                  .method_437(4))
                                                                                                   .method_351(class_77.method_411(class_1802.field_8264))
                                                                                                   .method_351(class_77.method_411(class_1802.field_8408))
                                                                                                   .method_351(class_77.method_411(class_1802.field_8446))));

        }
    }
}
