package poeticrainbow.rainbowchristmas.registry.block;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8923;

public class FauxSnowBlock extends class_8923 {
    public static final class_2754<FauxSnowShape> FAUX_SNOW_SHAPE;
    public static final class_2753 FACING;

    public FauxSnowBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9595().method_11664().method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.FLAT).method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FAUX_SNOW_SHAPE);
        builder.method_11667(FACING);
    }

    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        class_2561 fauxSnowTooltip = class_2561.method_43471("tooltip.rainbowchristmas.faux_snow");
        String[] lines = fauxSnowTooltip.getString().split("\\n");
        for (String line : lines) {
            tooltip.add(class_2561.method_30163(line).method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        super.method_9568(stack, context, tooltip, options);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return method_9541(-0.05, -2, -0.05, 16.05, 2, 16.05);
    }

    @Override
    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return stateFrom.method_26225();
        }
        return stateFrom.equals(state);
    }

    public class_2680 updateBlockStateFromBelow(class_2680 blockBelow, class_1937 world, class_2338 pos) {
        class_2680 defaultState = this.method_9595().method_11664();

        if (blockBelow.method_26206(world, pos, class_2350.field_11036)) {
            return defaultState;
        }

        // Slab handling
        double maxYBelow = blockBelow.method_26218(world, pos).method_1105(class_2350.class_2351.field_11052);
        if (maxYBelow > 0.375d && maxYBelow < 0.625) {
            defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.SLAB);
        }
        // Stair handling
        if (blockBelow.method_28500(class_2741.field_12503).isPresent()) {
            defaultState = defaultState.method_11657(FACING, blockBelow.method_11654(class_2741.field_12481));
            switch (blockBelow.method_11654(class_2741.field_12503)) {
                case field_12710 -> defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.STRAIGHT);
                case field_12708 -> defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.OUTER_LEFT);
                case field_12709 -> defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.OUTER_RIGHT);
                case field_12712 -> defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.INNER_LEFT);
                case field_12713 -> defaultState = defaultState.method_11657(FAUX_SNOW_SHAPE, FauxSnowShape.INNER_RIGHT);
            }
        }

        return defaultState;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockBelow = ctx.method_8045().method_8320(ctx.method_8037().method_10074());
        class_2680 defaultState = this.method_9595().method_11664();

        if (blockBelow.method_26206(ctx.method_8045(), ctx.method_8037(), class_2350.field_11036)) {
            return defaultState;
        }

        return updateBlockStateFromBelow(blockBelow, ctx.method_8045(), ctx.method_8037());
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!this.method_9558(state, world, pos)) {
            world.method_39279(pos, this, 1);
        }

        if (world instanceof class_1937 worldWorld) {
            return updateBlockStateFromBelow(world.method_8320(pos.method_10074()), worldWorld, pos);
        }
        return state;
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            world.method_22352(pos, true);
        }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 blockBelow = world.method_8320(pos.method_10074());
        return !blockBelow.method_26215() && !blockBelow.method_27852(this);
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(FACING, mirror.method_10343(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    static {
        FAUX_SNOW_SHAPE = class_2754.method_11850("shape", FauxSnowShape.class);
        FACING = class_2741.field_12481;
    }

    public enum FauxSnowShape implements class_3542 {
        FLAT("full"),
        SLAB("slab"),
        STRAIGHT("straight_stair"),
        OUTER_LEFT("outer_left_stair"),
        OUTER_RIGHT("outer_right_stair"),
        INNER_LEFT("inner_left_stair"),
        INNER_RIGHT("inner_right_stair");

        private final String name;

        FauxSnowShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}
