package poeticrainbow.rainbowchristmas.registry.block;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8567;

public class IcicleBlock extends class_2248 {
    public static final class_2758 COUNT;
    public static final class_265 SHAPE;

    public IcicleBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664().method_11657(COUNT, 1));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(COUNT);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        if (blockState.method_27852(this)) {
            return blockState.method_11657(COUNT, Math.min(4, blockState.method_11654(COUNT) + 1));
        }
        return super.method_9605(ctx);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return canSurvive((class_1937) world, pos);
    }

    @Override
    public boolean method_9616(class_2680 state, class_1750 ctx) {
        if (ctx.method_8041().method_31574(this.method_8389()) && state.method_11654(COUNT) < 4) {
            return true;
        }

        return super.method_9616(state, ctx);
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List<class_1799> droppedItems = new java.util.ArrayList<>(List.of());
        for (int i = 0; i < state.method_11654(COUNT); i++) {
            droppedItems.addAll(super.method_9560(state, builder));
        }
        return droppedItems;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public boolean canSurvive(class_1937 world, class_2338 pos) {
        class_2680 blockAbove = world.method_8320(pos.method_10084());
        return blockAbove.method_26206(world, pos, class_2350.field_11033) || blockAbove.method_26164(class_3481.field_15503);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!canSurvive(world, pos)) {
            world.method_22352(pos, true);
        }
        super.method_9588(state, world, pos, random);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11036 && !canSurvive((class_1937) world, pos)) {
            world.method_39279(pos, this, 1);
        }
        return state;
    }

    static {
        COUNT = class_2758.method_11867("count", 1, 4);
        SHAPE = method_9541(2, 2, 2, 14, 16, 14);
    }
}
