package poeticrainbow.rainbowchristmas.registry.block;

import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

public class NorthPoleBlock extends class_2248 {
    public static class_2754<PoleShape> POLE_SHAPE;
    public static class_265 BOTTOM_SHAPE;
    public static class_265 MIDDLE_SHAPE;
    public static class_265 TOP_SHAPE;
    public static class_265 FULL_SHAPE;

    public NorthPoleBlock(class_2251 settings) {
        super(settings);
        method_9595().method_11664().method_11657(POLE_SHAPE, PoleShape.FULL);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POLE_SHAPE);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch(state.method_11654(POLE_SHAPE)) {
            case BOTTOM -> BOTTOM_SHAPE;
            case MIDDLE -> MIDDLE_SHAPE;
            case TOP -> TOP_SHAPE;
            case FULL -> FULL_SHAPE;
        };
    }

    public class_2680 getStateFromNeighborBlocks(class_1937 world, class_2338 pos) {
        class_2680 state = method_9564();

        class_2680 blockBelow = world.method_8320(pos.method_10074());
        class_2680 blockAbove = world.method_8320(pos.method_10084());
        boolean isPoleBelow = blockBelow.method_27852(this);
        boolean isPoleAbove = blockAbove.method_27852(this);

        if (isPoleBelow) {
            state = isPoleAbove ? state.method_11657(POLE_SHAPE, PoleShape.MIDDLE) : state.method_11657(POLE_SHAPE, PoleShape.TOP);
        }
        if (!isPoleAbove && !isPoleBelow) {
            state = state.method_11657(POLE_SHAPE, PoleShape.FULL);
        }
        return state;
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (neighborState.method_27852(this) && direction.method_10166().method_10178() && world instanceof class_1937 worldWorld) {
            return getStateFromNeighborBlocks(worldWorld, pos);
        }
        return state;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return getStateFromNeighborBlocks(ctx.method_8045(), ctx.method_8037());
    }

    static {
        MIDDLE_SHAPE = method_9541(4, 0, 4, 12, 16, 12);
        BOTTOM_SHAPE = class_259.method_1082(MIDDLE_SHAPE, method_9541(0, 0, 0, 16, 2, 16), class_247.field_1366);
        TOP_SHAPE = class_259.method_1082(MIDDLE_SHAPE, method_9541(0, 14, 0, 16, 16, 16), class_247.field_1366);
        FULL_SHAPE = class_259.method_1082(BOTTOM_SHAPE, TOP_SHAPE, class_247.field_1366);
        POLE_SHAPE = class_2754.method_11850("shape", PoleShape.class);
    }

    public enum PoleShape implements class_3542 {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top"),
        FULL("full");

        private final String name;

        PoleShape(String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return name;
        }

        @Override
        public String toString() {
            return method_15434();
        }
    }
}
