package poeticrainbow.rainbowchristmas.registry.block;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3726;
import net.minecraft.class_5819;

public class OrnamentBlock extends class_2318 {
    private static final class_265 UP_SHAPE;
    private static final class_265 NORTH_SHAPE;
    private static final class_265 EAST_SHAPE;
    private static final class_265 SOUTH_SHAPE;
    private static final class_265 WEST_SHAPE;
    private static final class_265 DOWN_SHAPE;

    public OrnamentBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(field_10927, class_2350.field_11033));
    }

    @Override
    protected MapCodec<? extends class_2318> method_53969() {
        return null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(field_10927);
    }

    public class_265 getVoxelShapeFromFacing(class_2680 state) {
        return switch (state.method_11654(field_10927)) {
            case field_11043 -> NORTH_SHAPE;
            case field_11034 -> EAST_SHAPE;
            case field_11035 -> SOUTH_SHAPE;
            case field_11039 -> WEST_SHAPE;
            case field_11033 -> DOWN_SHAPE;
            case field_11036 -> UP_SHAPE;
        };
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return getVoxelShapeFromFacing(state);
    }

    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43471("tooltip.rainbowchristmas.ornament").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        super.method_9568(stack, context, tooltip, options);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_243 point = new class_243(random.method_43057(), random.method_43057(), random.method_43057());
        Optional<class_243> closestPoint = getVoxelShapeFromFacing(state).method_33661(point);
        if (closestPoint.isPresent() && random.method_43057() < 0.2) {
            class_243 pointOnSurface = new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260()).method_1019(closestPoint.get());
            world.method_8406(class_2398.field_11207,
                    pointOnSurface.method_10216(), pointOnSurface.method_10214(), pointOnSurface.method_10215(),
                    0d, 0.0d, 0d);
        }
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(field_10927, ctx.method_8038());
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Override
    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(field_10927, mirror.method_10343(state.method_11654(field_10927)));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(field_10927, rotation.method_10503(state.method_11654(field_10927)));
    }

    static {
        NORTH_SHAPE = class_259.method_1081(0.3125, 0.125, 0.5625, 0.6875, 0.875, 1);
        EAST_SHAPE = class_259.method_1081(0, 0.125, 0.3125, 0.4375, 0.875, 0.6875);
        SOUTH_SHAPE = class_259.method_1081(0.3125, 0.125, 0, 0.6875, 0.875, 0.4375);
        WEST_SHAPE = class_259.method_1081(0.5625, 0.125, 0.3125, 1, 0.875, 0.6875);
        UP_SHAPE = class_259.method_1081(0.3125, 0, 0.3125, 0.6875, 0.625, 0.6875);
        DOWN_SHAPE = class_259.method_1081(0.3125, 0.375, 0.3125, 0.6875, 1, 0.6875);
    }
}
