package poeticrainbow.rainbowchristmas.registry.block;

import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;
import poeticrainbow.rainbowchristmas.util.BlockInteractionUtil;

public class StrungDecorationBlock extends class_2248 {
    public static final class_2746 NORTH;
    public static final class_2746 EAST;
    public static final class_2746 SOUTH;
    public static final class_2746 WEST;

    public static final class_265 NORTH_SHAPE;
    public static final class_265 EAST_SHAPE;
    public static final class_265 SOUTH_SHAPE;
    public static final class_265 WEST_SHAPE;
    public static final class_265 ALL_SHAPE;

    public StrungDecorationBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664()
                .method_11657(NORTH, true)
                .method_11657(EAST, true)
                .method_11657(SOUTH, true)
                .method_11657(WEST, true));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(NORTH);
        builder.method_11667(EAST);
        builder.method_11667(SOUTH);
        builder.method_11667(WEST);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        // If the update came from a different height then ignore
        if (pos.method_10264() != neighborPos.method_10264() || neighborState.method_26204() instanceof StrungDecorationBlock) return state;
        if (world instanceof class_1937 worldWorld) {
            return getStateFromNeighbors(worldWorld, pos);
        } else {
            return state;
        }
    }

    public class_2680 getStateFromNeighbors(class_1937 world, class_2338 pos) {
        class_2680 allWallsState = super.method_9564();
        class_2680 hangingState = allWallsState.method_11657(NORTH, false).method_11657(EAST, false).method_11657(SOUTH, false).method_11657(WEST, false);

        if (world.method_8320(pos) == hangingState) {
            return hangingState;
        }

        // If neighbor has shape that touches the edges of the block
        class_265 slabShape = class_259.method_1081(0, 0, 0, 1, 0.5, 1);
        if (!class_259.method_1083(slabShape, world.method_8320(pos.method_10095()).method_26220(world, pos), class_2350.field_11035))
            allWallsState = allWallsState.method_11657(NORTH, false);
        if (!class_259.method_1083(slabShape, world.method_8320(pos.method_10078()).method_26220(world, pos), class_2350.field_11039))
            allWallsState = allWallsState.method_11657(EAST, false);
        if (!class_259.method_1083(slabShape, world.method_8320(pos.method_10072()).method_26220(world, pos), class_2350.field_11043))
            allWallsState = allWallsState.method_11657(SOUTH, false);
        if (!class_259.method_1083(slabShape, world.method_8320(pos.method_10067()).method_26220(world, pos), class_2350.field_11034))
            allWallsState = allWallsState.method_11657(WEST, false);

        return allWallsState;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 shape = class_259.method_1073();
        if (state.method_11654(NORTH)) shape = class_259.method_1082(shape, NORTH_SHAPE, class_247.field_1366);
        if (state.method_11654(EAST)) shape = class_259.method_1082(shape, EAST_SHAPE, class_247.field_1366);
        if (state.method_11654(SOUTH)) shape = class_259.method_1082(shape, SOUTH_SHAPE, class_247.field_1366);
        if (state.method_11654(WEST)) shape = class_259.method_1082(shape, WEST_SHAPE, class_247.field_1366);
        return shape;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.method_8608()) {
            class_1799 itemInHand = player.method_5998(hand);
            if (itemInHand.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
                class_2680 newState = state;
                class_2350 side = BlockInteractionUtil.getDirectionOfClosestSideFromHitPosition(hit.method_17784(), pos);
                switch (side) {
                    case field_11043 -> newState = newState.method_11657(SOUTH, false);
                    case field_11034 -> newState = newState.method_11657(WEST, false);
                    case field_11035 -> newState = newState.method_11657(NORTH, false);
                    case field_11039 -> newState = newState.method_11657(EAST, false);
                    default -> {
                        return class_9062.field_47733;
                    }
                }
                if (!player.method_7337()) itemInHand.method_7956(1, (class_3218) world, (class_3222) player, item -> {});
                world.method_8501(pos, newState);
                player.method_17356(class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
                return class_9062.field_47728;
            }
        }
        return class_9062.field_47731;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        if (ctx.method_8038() == class_2350.field_11033 || ctx.method_8038() == class_2350.field_11036) {
            return method_9564().method_11657(NORTH, false).method_11657(EAST, false).method_11657(SOUTH, false).method_11657(WEST, false);
        }
        return getStateFromNeighbors(ctx.method_8045(), ctx.method_8037());
    }

    @Override
    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        if (stateFrom.method_26204() instanceof StrungDecorationBlock) {
            boolean isStateHanging = !(state.method_11654(NORTH) || state.method_11654(EAST) || state.method_11654(SOUTH) || state.method_11654(WEST));
            boolean isStateFromHanging = !(stateFrom.method_11654(NORTH) || stateFrom.method_11654(EAST) || stateFrom.method_11654(SOUTH) || stateFrom.method_11654(WEST));
            // if hanging states match, then hide
            return isStateHanging == isStateFromHanging;
        }
        return false;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case field_11300 -> state.method_11657(NORTH, state.method_11654(SOUTH)).method_11657(SOUTH, state.method_11654(NORTH));
            case field_11301 -> state.method_11657(EAST, state.method_11654(WEST)).method_11657(WEST, state.method_11654(EAST));
            default -> state;
        };
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case field_11463 -> state.method_11657(NORTH, state.method_11654(WEST)).method_11657(EAST, state.method_11654(NORTH)).method_11657(SOUTH, state.method_11654(EAST)).method_11657(WEST, state.method_11654(SOUTH));
            case field_11464 -> state.method_11657(NORTH, state.method_11654(SOUTH)).method_11657(EAST, state.method_11654(WEST)).method_11657(SOUTH, state.method_11654(NORTH)).method_11657(WEST, state.method_11654(EAST));
            case field_11465 -> state.method_11657(NORTH, state.method_11654(EAST)).method_11657(WEST, state.method_11654(NORTH)).method_11657(SOUTH, state.method_11654(WEST)).method_11657(EAST, state.method_11654(SOUTH));
            default -> state;
        };
    }

    static {
        NORTH = class_2746.method_11825("north");
        EAST = class_2746.method_11825("east");
        SOUTH = class_2746.method_11825("south");
        WEST = class_2746.method_11825("west");

        NORTH_SHAPE = class_259.method_1081(0, 0, 0, 1, 1, 0.0625);
        EAST_SHAPE = class_259.method_1081(0.9375, 0, 0, 1, 1, 1);
        SOUTH_SHAPE = class_259.method_1081(0, 0, 0.9375, 1, 1, 1);
        WEST_SHAPE = class_259.method_1081(0, 0, 0, 0.0625, 1, 1);
        ALL_SHAPE = class_259.method_1082(
                class_259.method_1082(NORTH_SHAPE, EAST_SHAPE, class_247.field_1366),
                class_259.method_1082(SOUTH_SHAPE, WEST_SHAPE, class_247.field_1366),
                class_247.field_1366);
    }
}
