/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.PlayerJoinListener;
import io.github.Earth1283.fixLag.commands.FixLagCommand;
import io.github.Earth1283.fixLag.tasks.EntityCleanupTask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FixLag
extends JavaPlugin {
    private static final String LATEST_VERSION_URL = "https://raw.githubusercontent.com/Earth1283/FixLag/main/latest_version.txt";

    public void onEnable() {
        EntityCleanupTask cleanupTask = new EntityCleanupTask(this);
        FixLagCommand fixLagCommandExecutor = new FixLagCommand(cleanupTask);
        this.getCommand("fixlag").setExecutor((CommandExecutor)fixLagCommandExecutor);
        this.saveDefaultConfig();
        this.checkForUpdates();
        this.startCleanupTask(cleanupTask);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
    }

    public void onDisable() {
    }

    private void startCleanupTask(EntityCleanupTask cleanupTask) {
        int interval = this.getConfig().getInt("cleanup-interval", 300);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)cleanupTask, 0L, (long)interval * 20L);
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String currentVersion = this.getDescription().getVersion();
            String latestVersion = this.fetchLatestVersion();
            if (latestVersion != null && !currentVersion.equals(latestVersion)) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[FixLag] A new version (" + latestVersion + ") is available! You're running version " + currentVersion + ".");
                Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.YELLOW) + "[FixLag] Download the latest version here: https://modrinth.com/plugin/fixlag");
            }
        });
    }

    private String fetchLatestVersion() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(LATEST_VERSION_URL).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String latestVersion = reader.readLine();
            reader.close();
            return latestVersion != null ? latestVersion.trim() : null;
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[FixLag] Unable to check for updates: " + e.getMessage());
            return null;
        }
    }

    public boolean isUpdateAvailable() {
        String currentVersion = this.getDescription().getVersion();
        String latestVersion = this.fetchLatestVersion();
        return latestVersion != null && !currentVersion.equals(latestVersion);
    }
}

