/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag.tasks;

import io.github.Earth1283.fixLag.FixLag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.Plugin;

public class EntityCleanupTask
implements Runnable {
    private final FixLag plugin;
    private final int villagerThreshold;
    private final int itemThreshold;
    private final int tntThreshold;
    private final int minecartThreshold;
    private final int snowballThreshold;
    private final int cleanupInterval;
    private final int warningRefreshInterval;
    private int totalEntitiesCleared = 0;

    public EntityCleanupTask(FixLag plugin) {
        this.plugin = plugin;
        this.cleanupInterval = plugin.getConfig().getInt("cleanup-interval", 300);
        this.warningRefreshInterval = plugin.getConfig().getInt("warning-refresh-interval", 60);
        this.villagerThreshold = plugin.getConfig().getInt("entity-thresholds.villagers", 50);
        this.itemThreshold = plugin.getConfig().getInt("entity-thresholds.items", 100);
        this.tntThreshold = plugin.getConfig().getInt("entity-thresholds.primed-tnt", 75);
        this.minecartThreshold = plugin.getConfig().getInt("entity-thresholds.minecarts", 10);
        this.snowballThreshold = plugin.getConfig().getInt("entity-thresholds.snowballs", 50);
        this.startWarningRefreshTask();
    }

    @Override
    public void run() {
        this.notifyPlayers();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::clearEntities, 200L);
    }

    private void startWarningRefreshTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkEntityThresholds, 0L, (long)this.warningRefreshInterval * 20L);
    }

    private void notifyPlayers() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&a[FixLag] &bEntity cleanup in 3 minutes!")), (long)(this.cleanupInterval - 180) * 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&a[FixLag] &bEntity cleanup in 1 minute!")), (long)(this.cleanupInterval - 60) * 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&a[FixLag] &bEntity cleanup in 30 seconds!")), (long)(this.cleanupInterval - 30) * 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&a[FixLag] &bEntity cleanup in 10 seconds!")), (long)(this.cleanupInterval - 10) * 20L);
    }

    private void checkEntityThresholds() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
            ArrayList<String> minecartOverloadLocations = new ArrayList<String>();
            ArrayList<String> snowballOverloadLocations = new ArrayList<String>();
            for (World world : Bukkit.getWorlds()) {
                entityCounts.put("villagers", this.countEntities(world, Villager.class));
                entityCounts.put("items", this.countEntities(world, Item.class));
                entityCounts.put("tnt", this.countEntities(world, TNTPrimed.class));
                minecartOverloadLocations.addAll(this.checkEntityClusters(world, Minecart.class, this.minecartThreshold, 4.0));
                snowballOverloadLocations.addAll(this.checkEntityClusters(world, Snowball.class, this.snowballThreshold, 4.0));
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.notifyWarning(entityCounts, minecartOverloadLocations, snowballOverloadLocations));
        });
    }

    private List<String> checkEntityClusters(World world, Class<? extends Entity> entityType, int threshold, double radius) {
        ArrayList<String> overloadLocations = new ArrayList<String>();
        for (Chunk chunk : world.getLoadedChunks()) {
            Entity[] entitiesArray = chunk.getEntities();
            List<Entity> entities = Arrays.asList(entitiesArray);
            for (Entity entity : entities) {
                if (!entityType.isInstance(entity)) continue;
                Location loc = entity.getLocation();
                int blockX = loc.getBlockX();
                int blockY = loc.getBlockY();
                int blockZ = loc.getBlockZ();
                overloadLocations.add(world.getName() + " [" + blockX + ", " + blockY + ", " + blockZ + "]");
            }
        }
        return overloadLocations;
    }

    private <T extends Entity> int countNearbyEntities(Entity center, Class<T> entityType, double radius) {
        int count = 0;
        for (Entity entity : center.getNearbyEntities(radius, radius, radius)) {
            if (!entityType.isInstance(entity)) continue;
            ++count;
        }
        return count;
    }

    private void notifyWarning(Map<String, Integer> entityCounts, List<String> minecartOverloadLocations, List<String> snowballOverloadLocations) {
        StringBuilder warningMessage = new StringBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c[FixLag] &bWarning: Entity load threshold exceeded! "));
        if (entityCounts.get("villagers") > this.villagerThreshold) {
            warningMessage.append("&cMore than ").append(this.villagerThreshold).append(" Villagers loaded! ");
        }
        if (entityCounts.get("items") > this.itemThreshold) {
            warningMessage.append("&cMore than ").append(this.itemThreshold).append(" Items loaded! ");
        }
        if (entityCounts.get("tnt") > this.tntThreshold) {
            warningMessage.append("&cMore than ").append(this.tntThreshold).append(" TNT primed loaded! ");
        }
        if (!minecartOverloadLocations.isEmpty()) {
            warningMessage.append("&cMinecart overload detected at: ");
            for (String loc : minecartOverloadLocations) {
                warningMessage.append("\n  - ").append(loc);
            }
        }
        if (!snowballOverloadLocations.isEmpty()) {
            warningMessage.append("&cSnowball overload detected at: ");
            for (String loc : snowballOverloadLocations) {
                warningMessage.append("\n  - ").append(loc);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("fixlag.warning")) continue;
            player.sendMessage(warningMessage.toString());
        }
    }

    private <T extends Entity> int countEntities(World world, Class<T> entityType) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Chunk chunk : world.getLoadedChunks()) {
            for (Entity entity : chunk.getEntities()) {
                if (!entityType.isInstance(entity)) continue;
                entities.add((Entity)entityType.cast(entity));
            }
        }
        return entities.size();
    }

    public void clearEntities() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.totalEntitiesCleared = 0;
            for (World world : Bukkit.getWorlds()) {
                this.totalEntitiesCleared += this.removeEntities(world, TNTPrimed.class);
                this.totalEntitiesCleared += this.removeEntities(world, Minecart.class);
                this.totalEntitiesCleared += this.removeEntities(world, Item.class);
                this.totalEntitiesCleared += this.removeEntities(world, Arrow.class);
                this.totalEntitiesCleared += this.removeEntities(world, Snowball.class);
            }
            Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&a[FixLag] &bCleared " + this.totalEntitiesCleared + " entities (including arrows & snowballs)!")));
        });
    }

    private <T extends Entity> int removeEntities(World world, Class<T> entityType) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Chunk chunk : world.getLoadedChunks()) {
            for (Entity entity : chunk.getEntities()) {
                if (!entityType.isInstance(entity)) continue;
                entities.add((Entity)entityType.cast(entity));
            }
        }
        int removed = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof Entity)) continue;
            entity.remove();
            ++removed;
        }
        return removed;
    }
}

