/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag.tasks;

import io.github.Earth1283.fixLag.FixLag;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TPSWarningTask
extends BukkitRunnable {
    private final FixLag plugin;
    private boolean isWarningRed = true;
    private Set<String> ignoredPlayers = new HashSet<String>();

    public TPSWarningTask(FixLag plugin) {
        this.plugin = plugin;
    }

    public void run() {
        double tps = Bukkit.getServer().getTPS()[0];
        if (tps < 18.0) {
            String warningMessage = String.valueOf(ChatColor.RED) + "Warning: TPS " + String.format("%.2f", tps) + "!";
            if (!this.isWarningRed) {
                warningMessage = String.valueOf(ChatColor.YELLOW) + "Warning: TPS " + String.format("%.2f", tps) + "!";
            }
            this.isWarningRed = !this.isWarningRed;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("fixlag.tpswarn") || this.ignoredPlayers.contains(player.getName())) continue;
                TextComponent textComponent = new TextComponent(warningMessage);
                textComponent.setBold(Boolean.valueOf(true));
                player.spigot().sendMessage((BaseComponent)textComponent);
            }
        }
    }

    public void ignoreWarning(Player player) {
        this.ignoredPlayers.add(player.getName());
    }

    public void unignoreWarning(Player player) {
        this.ignoredPlayers.remove(player.getName());
    }

    public boolean isIgnoring(Player player) {
        return this.ignoredPlayers.contains(player.getName());
    }
}

