/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private Set<String> entitiesToDelete;
    private long deletionIntervalTicks;
    private boolean enableWarning;
    private long warningTimeTicks;
    private long overloadCheckIntervalTicks;
    private boolean logMemoryStats;
    private long updateCheckIntervalTicks;
    private String updateUrl;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.plugin.reloadConfig();
        this.entitiesToDelete = new HashSet<String>(config.getStringList("entities-to-delete"));
        this.deletionIntervalTicks = config.getLong("deletion-interval-seconds", 60L) * 20L;
        this.enableWarning = config.getBoolean("enable-warning", true);
        this.warningTimeTicks = config.getLong("warning-time-seconds", 5L) * 20L;
        this.overloadCheckIntervalTicks = config.getLong("overload-detection.check-interval-seconds", 30L) * 20L;
        this.logMemoryStats = config.getBoolean("log-memory-stats", false);
        this.updateCheckIntervalTicks = config.getLong("update-check-interval-seconds", 86400L) * 20L;
        this.updateUrl = config.getString("update-url", "https://api.modrinth.com/v2/project/fixlag/version");
        this.validateConfigValues();
    }

    private void validateConfigValues() {
        if (this.deletionIntervalTicks <= 0L) {
            this.plugin.getLogger().log(Level.WARNING, "Deletion interval is invalid! Using default value of 60 seconds.");
            this.deletionIntervalTicks = 1200L;
        }
        if (this.warningTimeTicks < 0L) {
            this.plugin.getLogger().log(Level.WARNING, "Warning time is invalid! Using default value of 5 seconds.");
            this.warningTimeTicks = 100L;
        }
        if (this.overloadCheckIntervalTicks <= 0L) {
            this.plugin.getLogger().log(Level.WARNING, "Overload check interval is invalid! Using default value of 30 seconds.");
            this.overloadCheckIntervalTicks = 600L;
        }
        if (this.updateCheckIntervalTicks <= 0L) {
            this.plugin.getLogger().log(Level.WARNING, "Update check interval is invalid! Using default value of 1 day.");
            this.updateCheckIntervalTicks = 1728000L;
        }
    }

    public Set<String> getEntitiesToDelete() {
        return this.entitiesToDelete;
    }

    public long getDeletionIntervalTicks() {
        return this.deletionIntervalTicks;
    }

    public boolean isEnableWarning() {
        return this.enableWarning;
    }

    public long getWarningTimeTicks() {
        return this.warningTimeTicks;
    }

    public long getOverloadCheckIntervalTicks() {
        return this.overloadCheckIntervalTicks;
    }

    public boolean isLogMemoryStats() {
        return this.logMemoryStats;
    }

    public long getUpdateCheckIntervalTicks() {
        return this.updateCheckIntervalTicks;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }
}

