/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.Earth1283.fixLag.ConfigManager;
import io.github.Earth1283.fixLag.MessageManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final Gson gson = new Gson();

    public UpdateChecker(JavaPlugin plugin, ConfigManager configManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
    }

    public void startUpdateCheckTask() {
        new BukkitRunnable(){

            public void run() {
                try {
                    String latestVersion = UpdateChecker.this.getLatestVersion();
                    if (latestVersion != null) {
                        if (!UpdateChecker.this.plugin.getDescription().getVersion().equals(latestVersion)) {
                            UpdateChecker.this.plugin.getLogger().log(Level.INFO, UpdateChecker.this.messageManager.getLogMessage("log_update_available", "%version%", latestVersion));
                            UpdateChecker.this.notifyUpdate(latestVersion);
                        } else {
                            UpdateChecker.this.plugin.getLogger().log(Level.INFO, UpdateChecker.this.messageManager.getLogMessage("log_update_uptodate", new String[0]));
                        }
                    } else {
                        UpdateChecker.this.plugin.getLogger().log(Level.WARNING, UpdateChecker.this.messageManager.getLogMessage("log_update_check_failed", new String[0]));
                    }
                }
                catch (IOException e) {
                    UpdateChecker.this.plugin.getLogger().log(Level.WARNING, UpdateChecker.this.messageManager.getLogMessage("log_update_check_error", "%error%", e.getMessage()));
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, this.configManager.getUpdateCheckIntervalTicks());
    }

    private String getLatestVersion() throws IOException {
        URL url = new URL(this.configManager.getUpdateUrl());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            JsonObject latestVersionObject;
            JsonElement latestVersionElement;
            JsonArray versions = (JsonArray)this.gson.fromJson((Reader)reader, JsonArray.class);
            if (versions != null && !versions.isJsonNull() && versions.size() > 0 && (latestVersionElement = versions.get(0)).isJsonObject() && (latestVersionObject = latestVersionElement.getAsJsonObject()).has("version_number")) {
                String string = latestVersionObject.get("version_number").getAsString();
                return string;
            }
            String string = null;
            return string;
        }
    }

    private void notifyUpdate(String latestVersion) {
        String message = this.messageManager.getMessage("update_available", "%latest_version%", latestVersion) + this.messageManager.getMessage("update_current_version", "%current_version%", this.plugin.getDescription().getVersion());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp() && !player.hasPermission("fixlag.notify.update")) continue;
            player.sendMessage(message);
        }
    }
}

