/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.MessageManager;
import io.github.Earth1283.fixLag.PerformanceMonitor;
import io.github.Earth1283.fixLag.TaskManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final TaskManager taskManager;
    private final PerformanceMonitor performanceMonitor;
    private final MessageManager messageManager;

    public CommandManager(JavaPlugin plugin, TaskManager taskManager, PerformanceMonitor performanceMonitor, MessageManager messageManager) {
        this.plugin = plugin;
        this.taskManager = taskManager;
        this.performanceMonitor = performanceMonitor;
        this.messageManager = messageManager;
        this.registerCommands();
    }

    private void registerCommands() {
        PluginCommand serverinfo;
        PluginCommand gcinfo;
        PluginCommand fixlag = this.plugin.getCommand("fixlag");
        if (fixlag != null) {
            fixlag.setExecutor((CommandExecutor)this);
        }
        if ((gcinfo = this.plugin.getCommand("gcinfo")) != null) {
            gcinfo.setExecutor((CommandExecutor)this);
        }
        if ((serverinfo = this.plugin.getCommand("serverinfo")) != null) {
            serverinfo.setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "fixlag": {
                return this.handleFixLagCommand(sender);
            }
            case "gcinfo": {
                return this.handleGc\u0130nfoCommand(sender);
            }
            case "serverinfo": {
                return this.handleServer\u0130nfoCommand(sender);
            }
        }
        return false;
    }

    private boolean handleFixLagCommand(CommandSender sender) {
        if (!sender.hasPermission("fixlag.command")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", false, new String[0]));
            return true;
        }
        sender.sendMessage(this.messageManager.getMessage("entity_clear_manual", false, new String[0]));
        this.taskManager.deleteAndAnnounce();
        return true;
    }

    private boolean handleGc\u0130nfoCommand(CommandSender sender) {
        if (!sender.hasPermission("fixlag.gcinfo")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", false, new String[0]));
            return true;
        }
        sender.sendMessage(this.performanceMonitor.getMemoryAndGCInfo());
        return true;
    }

    private boolean handleServer\u0130nfoCommand(CommandSender sender) {
        if (!sender.hasPermission("fixlag.serverinfo")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", false, new String[0]));
            return true;
        }
        sender.sendMessage(this.performanceMonitor.getServerInfo());
        return true;
    }
}

