/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private final MiniMessage miniMessage;
    private final LegacyComponentSerializer legacySerializer;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacySection();
        this.loadMessages();
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    public String getMessage(String key, boolean includePrefix, String ... replacements) {
        Object raw = this.messagesConfig.getString(key, "Error: Message key '" + key + "' not found in messages.yml");
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            raw = ((String)raw).replace(replacements[i], replacements[i + 1]);
        }
        if (includePrefix) {
            String prefixRaw = this.messagesConfig.getString("prefix", "<gray>[<green>FixLag<gray>] <reset>");
            raw = prefixRaw + (String)raw;
        }
        Component comp = this.miniMessage.deserialize(raw);
        return this.legacySerializer.serialize(comp);
    }

    public String getMessage(String key, String ... replacements) {
        return this.getMessage(key, true, replacements);
    }

    public String getLogMessage(String key, String ... replacements) {
        String raw = this.messagesConfig.getString(key, "Error: Log message key '" + key + "' not found in messages.yml");
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            raw = raw.replace(replacements[i], replacements[i + 1]);
        }
        Component comp = this.miniMessage.deserialize((Object)raw);
        return this.legacySerializer.serialize(comp);
    }

    public String getRawMessage(String key) {
        return this.messagesConfig.getString(key, "");
    }
}

