/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.ConfigManager;
import io.github.Earth1283.fixLag.MessageManager;
import io.github.Earth1283.fixLag.PerformanceMonitor;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskManager {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final PerformanceMonitor performanceMonitor;

    public TaskManager(JavaPlugin plugin, ConfigManager configManager, MessageManager messageManager, PerformanceMonitor performanceMonitor) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
        this.performanceMonitor = performanceMonitor;
    }

    public void startDeletionTask() {
        new BukkitRunnable(){

            public void run() {
                long warningSchedule;
                if (TaskManager.this.configManager.getEntitiesToDelete() == null || TaskManager.this.configManager.getEntitiesToDelete().isEmpty()) {
                    return;
                }
                if (TaskManager.this.configManager.isEnableWarning() && (warningSchedule = TaskManager.this.configManager.getDeletionIntervalTicks() - TaskManager.this.configManager.getWarningTimeTicks()) >= 0L) {
                    Bukkit.getScheduler().runTaskLater((Plugin)TaskManager.this.plugin, TaskManager.this::sendWarning, warningSchedule);
                }
                Bukkit.getScheduler().runTaskLater((Plugin)TaskManager.this.plugin, TaskManager.this::deleteAndAnnounce, TaskManager.this.configManager.getDeletionIntervalTicks());
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, this.configManager.getDeletionIntervalTicks());
    }

    private void sendWarning() {
        long warningTimeSeconds = this.configManager.getWarningTimeTicks() / 20L;
        String formattedMessage = this.messageManager.getMessage("entity_clear_warning", "%fixlag_time%", String.valueOf(warningTimeSeconds));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(formattedMessage);
        }
    }

    public void deleteAndAnnounce() {
        int deletedCount = this.deleteEntities();
        if (deletedCount > 0) {
            String broadcastMessage = this.messageManager.getMessage("entity_clear_broadcast", "%fixlag_count%", String.valueOf(deletedCount));
            Bukkit.getServer().broadcast((Component)Component.text((String)broadcastMessage));
            if (this.configManager.isLogMemoryStats()) {
                this.performanceMonitor.logMemoryUsage();
            }
            this.plugin.getLogger().log(Level.INFO, this.messageManager.getLogMessage("log_entity_deleted", "%fixlag_count%", String.valueOf(deletedCount)));
        }
    }

    private int deleteEntities() {
        int deletedEntities = 0;
        Set<String> entitiesToDelete = this.configManager.getEntitiesToDelete();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.isValid() || !entitiesToDelete.contains(entity.getType().name())) continue;
                entity.remove();
                ++deletedEntities;
            }
        }
        return deletedEntities;
    }
}

