/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.DeletedItemsManager;
import io.github.Earth1283.fixLag.MessageManager;
import io.github.Earth1283.fixLag.PerformanceMonitor;
import io.github.Earth1283.fixLag.TaskManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final TaskManager taskManager;
    private final PerformanceMonitor performanceMonitor;
    private final MessageManager messageManager;
    private final DeletedItemsManager deletedItemsManager;

    public CommandManager(JavaPlugin plugin, TaskManager taskManager, PerformanceMonitor performanceMonitor, MessageManager messageManager, DeletedItemsManager deletedItemsManager) {
        this.plugin = plugin;
        this.taskManager = taskManager;
        this.performanceMonitor = performanceMonitor;
        this.messageManager = messageManager;
        this.deletedItemsManager = deletedItemsManager;
        this.registerCommands();
    }

    private void registerCommands() {
        PluginCommand serverinfo;
        PluginCommand gcinfo;
        PluginCommand fixlag = this.plugin.getCommand("fixlag");
        if (fixlag != null) {
            fixlag.setExecutor((CommandExecutor)this);
            fixlag.setTabCompleter((TabCompleter)this);
        }
        if ((gcinfo = this.plugin.getCommand("gcinfo")) != null) {
            gcinfo.setExecutor((CommandExecutor)this);
        }
        if ((serverinfo = this.plugin.getCommand("serverinfo")) != null) {
            serverinfo.setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "fixlag": {
                return this.handleFixLagCommand(sender, args);
            }
            case "gcinfo": {
                return this.handleGc\u0130nfoCommand(sender);
            }
            case "serverinfo": {
                return this.handleServer\u0130nfoCommand(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("fixlag") && args.length == 1) {
            ArrayList<String> subcommands = new ArrayList<String>(Arrays.asList("retrieve", "reload"));
            subcommands.removeIf(s -> !s.toLowerCase().startsWith(args[0].toLowerCase()));
            return subcommands;
        }
        return null;
    }

    private boolean handleFixLagCommand(CommandSender sender, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("retrieve")) {
            if (!sender.hasPermission("fixlag.retrieve")) {
                sender.sendMessage(this.messageManager.getMessage("permission_denied", new String[0]));
                return true;
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.deletedItemsManager.openChestGUI(player);
            } else {
                sender.sendMessage("This command can only be used by players.");
            }
            return true;
        }
        if (!sender.hasPermission("fixlag.command")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", new String[0]));
            return true;
        }
        sender.sendMessage(this.messageManager.getMessage("entity_clear_manual", new String[0]));
        this.taskManager.deleteAndAnnounce();
        return true;
    }

    private boolean handleGc\u0130nfoCommand(CommandSender sender) {
        if (!sender.hasPermission("fixlag.gcinfo")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", new String[0]));
            return true;
        }
        sender.sendMessage(this.performanceMonitor.getMemoryAndGCInfo());
        return true;
    }

    private boolean handleServer\u0130nfoCommand(CommandSender sender) {
        if (!sender.hasPermission("fixlag.serverinfo")) {
            sender.sendMessage(this.messageManager.getMessage("permission_denied", new String[0]));
            return true;
        }
        sender.sendMessage(this.performanceMonitor.getServerInfo());
        return true;
    }
}

