/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.FixLag;
import io.github.Earth1283.fixLag.MessageManager;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeletedItemsManager {
    private final JavaPlugin plugin;
    private final MessageManager messageManager;
    private final ConcurrentLinkedQueue<ItemStack> deletedItems = new ConcurrentLinkedQueue();
    private Inventory sharedChest;
    private boolean isCleanupScheduled = false;
    private static final int CHEST_SIZE = 54;
    private static final String CHEST_TITLE = "Recovered Items";

    public DeletedItemsManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.messageManager = ((FixLag)plugin).getMessageManager();
    }

    public void addDeletedItems(List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        this.deletedItems.addAll(items);
        if (!this.isCleanupScheduled) {
            this.isCleanupScheduled = true;
            this.startCleanupTimer();
        }
    }

    public void openChestGUI(Player player) {
        if (this.deletedItems.isEmpty()) {
            player.sendMessage(this.messageManager.getMessage("retrieve_command_no_items", new String[0]));
            return;
        }
        if (this.sharedChest == null) {
            this.sharedChest = Bukkit.createInventory(null, (int)54, (String)CHEST_TITLE);
            this.updateChestContents();
        }
        player.openInventory(this.sharedChest);
    }

    private void updateChestContents() {
        if (this.sharedChest == null) {
            return;
        }
        this.sharedChest.clear();
        for (ItemStack item : this.deletedItems) {
            if (item == null || item.getType() == Material.AIR) continue;
            this.sharedChest.addItem(new ItemStack[]{item});
        }
    }

    private void startCleanupTimer() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::clearDeletedItems, 900L);
    }

    private void clearDeletedItems() {
        if (this.sharedChest != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getOpenInventory().getTitle().equals(CHEST_TITLE)) continue;
                player.closeInventory();
            }
            this.sharedChest = null;
        }
        this.deletedItems.clear();
        this.isCleanupScheduled = false;
    }
}

