/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.OverloadChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FixLag
extends JavaPlugin {
    private static final String UPDATE_URL = "https://github.com/Earth1283/FixLag/blob/main/latest_version.txt";
    private List<String> entitiesToDelete;
    private long deletionIntervalTicks;
    private boolean enableWarning;
    private long warningTimeTicks;
    private OverloadChecker overloadChecker;
    private long overloadCheckIntervalTicks;
    private boolean logMemoryStats;
    private long updateCheckIntervalTicks;
    private FileConfiguration messagesConfig;
    private MiniMessage miniMessage;
    private LegacyComponentSerializer legacySerializer;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadMessages();
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacySection();
        this.overloadChecker = new OverloadChecker(this, this.entitiesToDelete);
        this.overloadChecker.startChecking(this.overloadCheckIntervalTicks, this.overloadCheckIntervalTicks);
        this.startDeletionTask();
        this.startUpdateCheckTask();
        this.getLogger().log(Level.INFO, "FixLag plugin has been enabled!");
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private String getMessage(String key, boolean includePrefix, String ... replacements) {
        Object raw = this.messagesConfig.getString(key, "Error: Message key '" + key + "' not found in messages.yml");
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            raw = ((String)raw).replace(replacements[i], replacements[i + 1]);
        }
        if (includePrefix) {
            String prefixRaw = this.messagesConfig.getString("prefix", "<gray>[<green>FixLag<gray>] <reset>");
            raw = prefixRaw + (String)raw;
        }
        Component comp = this.miniMessage.deserialize(raw);
        return this.legacySerializer.serialize(comp);
    }

    private String getMessage(String key, String ... replacements) {
        return this.getMessage(key, true, replacements);
    }

    private String getLogMessage(String key, String ... replacements) {
        String raw = this.messagesConfig.getString(key, "Error: Log message key '" + key + "' not found in messages.yml");
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            raw = raw.replace(replacements[i], replacements[i + 1]);
        }
        Component comp = this.miniMessage.deserialize((Object)raw);
        return PlainTextComponentSerializer.plainText().serialize(comp);
    }

    public void onDisable() {
        if (this.overloadChecker != null) {
            this.overloadChecker.stopChecking();
        }
        this.getLogger().log(Level.INFO, "FixLag plugin has been disabled!");
        this.getLogger().log(Level.INFO, "Goodbye!");
    }

    public void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.entitiesToDelete = config.getStringList("entities-to-delete");
        this.deletionIntervalTicks = config.getLong("deletion-interval-seconds") * 20L;
        this.enableWarning = config.getBoolean("enable-warning");
        this.warningTimeTicks = config.getLong("warning-time-seconds") * 20L;
        this.overloadCheckIntervalTicks = config.getLong("overload-detection.check-interval-seconds", 30L) * 20L;
        this.logMemoryStats = config.getBoolean("log-memory-stats", false);
        this.updateCheckIntervalTicks = config.getLong("update-check-interval-seconds", 86400L) * 20L;
        if (this.deletionIntervalTicks <= 0L) {
            this.getLogger().log(Level.WARNING, "Deletion interval is invalid! Using default value of 60 seconds.");
            this.deletionIntervalTicks = 1200L;
        }
        if (this.warningTimeTicks < 0L) {
            this.getLogger().log(Level.WARNING, "Warning time is invalid! Using default value of 5 seconds.");
            this.warningTimeTicks = 100L;
        }
        if (this.overloadCheckIntervalTicks <= 0L) {
            this.getLogger().log(Level.WARNING, "Overload check interval is invalid! Using default value of 30 seconds.");
            this.overloadCheckIntervalTicks = 600L;
        }
        if (this.updateCheckIntervalTicks <= 0L) {
            this.getLogger().log(Level.WARNING, "Update check interval is invalid! Using default value of 1 day.");
            this.updateCheckIntervalTicks = 1728000L;
        }
    }

    public void startDeletionTask() {
        new BukkitRunnable(){

            public void run() {
                if (FixLag.this.entitiesToDelete == null || FixLag.this.entitiesToDelete.isEmpty()) {
                    return;
                }
                long warningSchedule = FixLag.this.deletionIntervalTicks - FixLag.this.warningTimeTicks;
                if (FixLag.this.enableWarning && warningSchedule >= 0L) {
                    Bukkit.getScheduler().runTaskLater((Plugin)FixLag.this, () -> {
                        long warningTimeSeconds = FixLag.this.warningTimeTicks / 20L;
                        String formattedMessage = FixLag.this.getMessage("entity_clear_warning", "%time%", String.valueOf(warningTimeSeconds));
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendMessage(formattedMessage);
                        }
                    }, warningSchedule);
                }
                Bukkit.getScheduler().runTaskLater((Plugin)FixLag.this, () -> {
                    int deletedCount = FixLag.this.deleteEntities();
                    if (deletedCount > 0) {
                        String broadcastMessage = FixLag.this.getMessage("entity_clear_broadcast", "%count%", String.valueOf(deletedCount));
                        Bukkit.getServer().broadcastMessage(broadcastMessage);
                        if (FixLag.this.logMemoryStats) {
                            FixLag.this.logMemoryUsage();
                        }
                        FixLag.this.getLogger().log(Level.INFO, FixLag.this.getLogMessage("log_entity_deleted", "%count%", String.valueOf(deletedCount)));
                    }
                }, FixLag.this.enableWarning ? FixLag.this.deletionIntervalTicks : 0L);
            }
        }.runTaskTimer((Plugin)this, 0L, this.deletionIntervalTicks);
    }

    public int deleteEntities() {
        int deletedEntities = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.isValid() || !this.entitiesToDelete.contains(entity.getType().name().toUpperCase())) continue;
                entity.remove();
                ++deletedEntities;
            }
        }
        return deletedEntities;
    }

    public String getMemoryAndGCInfo() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        long usedHeapMB = heapMemoryUsage.getUsed() / 0x100000L;
        long maxHeapMB = heapMemoryUsage.getMax() / 0x100000L;
        long freeHeapMB = maxHeapMB - usedHeapMB;
        long usedNonHeapMB = nonHeapMemoryUsage.getUsed() / 0x100000L;
        long maxNonHeapMB = nonHeapMemoryUsage.getMax() / 0x100000L;
        long freeNonHeapMB = maxNonHeapMB - usedNonHeapMB;
        List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        StringBuilder gcStats = new StringBuilder();
        for (GarbageCollectorMXBean garbageCollectorMXBean : gcMXBeans) {
            gcStats.append(garbageCollectorMXBean.getName()).append(": Collections=").append(garbageCollectorMXBean.getCollectionCount()).append(", Time=").append(garbageCollectorMXBean.getCollectionTime()).append("ms\n");
        }
        StringBuilder gcType = new StringBuilder();
        for (GarbageCollectorMXBean gcBean : gcMXBeans) {
            if (gcType.length() > 0) {
                gcType.append(", ");
            }
            gcType.append(gcBean.getName());
        }
        String string = this.messagesConfig.getString("gc_info_header", "<bold>GC Info</bold>");
        String raw = string + "\n<aqua>Garbage Collector: <green>" + gcType.toString() + "</green></aqua>\n<aqua>Heap Memory:</aqua> Used=<green>" + usedHeapMB + "MB</green>, Free=<green>" + freeHeapMB + "MB</green>, Max=<green>" + maxHeapMB + "MB</green>\n<aqua>Non-Heap Memory:</aqua> Used=<green>" + usedNonHeapMB + "MB</green>, Free=<green>" + freeNonHeapMB + "MB</green>, Max=<green>" + maxNonHeapMB + "MB</green>\n<aqua>GC Stats:</aqua>\n" + gcStats.toString();
        Component comp = this.miniMessage.deserialize((Object)raw);
        return this.legacySerializer.serialize(comp);
    }

    public void logMemoryUsage() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        long usedHeapMB = heapMemoryUsage.getUsed() / 0x100000L;
        long maxHeapMB = heapMemoryUsage.getMax() / 0x100000L;
        long freeHeapMB = maxHeapMB - usedHeapMB;
        long usedNonHeapMB = nonHeapMemoryUsage.getUsed() / 0x100000L;
        long maxNonHeapMB = nonHeapMemoryUsage.getMax() / 0x100000L;
        long freeNonHeapMB = maxNonHeapMB - usedNonHeapMB;
        List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        StringBuilder gcStats = new StringBuilder();
        for (GarbageCollectorMXBean gcBean : gcMXBeans) {
            gcStats.append(gcBean.getName()).append(": Collections=").append(gcBean.getCollectionCount()).append(", Time=" + gcBean.getCollectionTime()).append("ms | ");
        }
        if (gcStats.length() > 2) {
            gcStats.setLength(gcStats.length() - 3);
        }
        this.getLogger().log(Level.INFO, "Memory Stats - Heap: Used=" + usedHeapMB + "MB, Free=" + freeHeapMB + "MB, Max=" + maxHeapMB + "MB | Non-Heap: Used=" + usedNonHeapMB + "MB, Free=" + freeNonHeapMB + "MB, Max=" + maxNonHeapMB + "MB | GC: " + gcStats.toString());
    }

    private String formatDouble(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(d);
    }

    public String getServerInfo() {
        double[] tps = Bukkit.getServer().getTPS();
        long usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        double memoryUsagePercentage = (double)usedMemory / (double)totalMemory * 100.0;
        long averageMspt1 = Math.round(1000.0 / tps[0]);
        long averageMspt5 = Math.round(1000.0 / tps[1]);
        long averageMspt15 = Math.round(1000.0 / tps[2]);
        String jvmVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        double cpuLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        Object cpuUsage = "N/A";
        cpuUsage = cpuLoad >= 0.0 ? this.formatDouble(cpuLoad * 100.0 / (double)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors()) + "%" : "Unavailable";
        String headerRaw = this.messagesConfig.getString("server_info_header", "<bold>Server Info</bold>");
        String raw = headerRaw + "\n<aqua>JVM Version: <green>" + jvmVersion + "</green></aqua>\n<aqua>JVM Name: <green>" + jvmName + "</green></aqua>\n<aqua>OS Architecture: <green>" + osArch + "</green></aqua>\n<aqua>OS Name: <green>" + osName + "</green></aqua>\n" + this.messagesConfig.getString("server_info_tps", "<aqua>TPS:</aqua> 1m=<green>%tps_1m%</green>, 5m=<green>%tps_5m%</green>, 15m=<green>%tps_15m%</green>").replace("%tps_1m%", this.formatDouble(tps[0])).replace("%tps_5m%", this.formatDouble(tps[1])).replace("%tps_15m%", this.formatDouble(tps[2])) + "\n<aqua>MSPT (Last 1m): <green>" + averageMspt1 + " ms</green></aqua>\n<aqua>MSPT (Last 5m): <green>" + averageMspt5 + " ms</green></aqua>\n<aqua>MSPT (Last 15m): <green>" + averageMspt15 + " ms</green></aqua>\n" + this.messagesConfig.getString("server_info_ram", "<aqua>RAM:</aqua> Used=<green>%used_ram%MB</green>, Total=<green>%total_ram%MB</green>, Percent=<green>%ram_percentage%</green>").replace("%used_ram%", String.valueOf(usedMemory)).replace("%total_ram%", String.valueOf(totalMemory)).replace("%ram_percentage%", this.formatDouble(memoryUsagePercentage)) + "\n" + this.messagesConfig.getString("server_info_cpu", "<aqua>CPU Usage: <green>%cpu_usage%</green></aqua>").replace("%cpu_usage%", (CharSequence)cpuUsage);
        Component comp = this.miniMessage.deserialize((Object)raw);
        return this.legacySerializer.serialize(comp);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("fixlag")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.isOp() || player.hasPermission("fixlag.command")) {
                    player.sendMessage(this.getMessage("entity_clear_manual", false, new String[0]));
                    Bukkit.getScheduler().runTask((Plugin)this, this::deleteAndAnnounce);
                    return true;
                }
                player.sendMessage(this.getMessage("permission_denied", false, new String[0]));
                return true;
            }
            sender.sendMessage(this.getMessage("entity_clear_manual", false, new String[0]));
            Bukkit.getScheduler().runTask((Plugin)this, this::deleteAndAnnounce);
            return true;
        }
        if (command.getName().equalsIgnoreCase("gcinfo")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.isOp() || player.hasPermission("fixlag.gcinfo")) {
                    player.sendMessage(this.getMemoryAndGCInfo());
                    return true;
                }
                player.sendMessage(this.getMessage("permission_denied", false, new String[0]));
                return true;
            }
            sender.sendMessage(this.getMemoryAndGCInfo());
            return true;
        }
        if (command.getName().equalsIgnoreCase("serverinfo")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.isOp() || player.hasPermission("fixlag.serverinfo")) {
                    player.sendMessage(this.getServerInfo());
                    return true;
                }
                player.sendMessage(this.getMessage("permission_denied", false, new String[0]));
                return true;
            }
            sender.sendMessage(this.getServerInfo());
            return true;
        }
        return false;
    }

    private void deleteAndAnnounce() {
        int deletedCount = this.deleteEntities();
        if (deletedCount > 0) {
            String broadcastMessage = this.getMessage("entity_clear_broadcast", "%count%", String.valueOf(deletedCount));
            Bukkit.getServer().broadcastMessage(broadcastMessage);
            if (this.logMemoryStats) {
                this.logMemoryUsage();
            }
            this.getLogger().log(Level.INFO, this.getLogMessage("log_entity_deleted", "%count%", String.valueOf(deletedCount)));
        }
    }

    public void startUpdateCheckTask() {
        new BukkitRunnable(){

            public void run() {
                try {
                    String latestVersion = FixLag.this.getLatestVersion();
                    if (latestVersion != null) {
                        if (!FixLag.this.getDescription().getVersion().equals(latestVersion)) {
                            FixLag.this.getLogger().log(Level.INFO, FixLag.this.getLogMessage("log_update_available", "%version%", latestVersion));
                            FixLag.this.notifyUpdate(latestVersion);
                        } else {
                            FixLag.this.getLogger().log(Level.INFO, FixLag.this.getLogMessage("log_update_uptodate", new String[0]));
                        }
                    } else {
                        FixLag.this.getLogger().log(Level.WARNING, FixLag.this.getLogMessage("log_update_check_failed", new String[0]));
                    }
                }
                catch (IOException e) {
                    FixLag.this.getLogger().log(Level.WARNING, FixLag.this.getLogMessage("log_update_check_error", "%error%", e.getMessage()));
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this, 0L, this.updateCheckIntervalTicks);
    }

    private String getLatestVersion() throws IOException {
        URL url = new URL(UPDATE_URL);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        return reader.readLine();
    }

    private void notifyUpdate(String latestVersion) {
        String message = this.getMessage("update_available", "%latest_version%", latestVersion) + this.getMessage("update_current_version", "%current_version%", this.getDescription().getVersion());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp() && !player.hasPermission("fixlag.notify.update")) continue;
            player.sendMessage(message);
        }
    }
}

