/*
 * Decompiled with CFR 0.152.
 */
package io.github.Earth1283.fixLag;

import io.github.Earth1283.fixLag.FixLag;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class OverloadChecker {
    private final FixLag plugin;
    private final List<String> entitiesToDelete;
    private int overloadRadius;
    private int criticalEntityCount;
    private BukkitTask checkTask;

    public OverloadChecker(FixLag plugin, List<String> entitiesToDelete) {
        this.plugin = plugin;
        this.entitiesToDelete = entitiesToDelete;
        this.loadConfig();
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.overloadRadius = config.getInt("overload-detection.radius", 50);
        this.criticalEntityCount = config.getInt("overload-detection.critical-entity-count", 30);
    }

    public void startChecking(long delayTicks, long periodTicks) {
        this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            List<Player> onlinePlayers = List.copyOf(Bukkit.getOnlinePlayers());
            for (Player player : onlinePlayers) {
                UUID playerUUID = player.getUniqueId();
                Location playerLocation = player.getLocation();
                World world = playerLocation.getWorld();
                if (world == null) continue;
                List nearbyEntities = world.getNearbyEntities(playerLocation, (double)this.overloadRadius, (double)this.overloadRadius, (double)this.overloadRadius).stream().collect(Collectors.toList());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List typeFilteredEntities = nearbyEntities.stream().filter(entity -> this.entitiesToDelete.contains(entity.getType().name().toUpperCase())).collect(Collectors.toList());
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        List permissionFilteredEntities;
                        int finalCount;
                        Player p = Bukkit.getPlayer((UUID)playerUUID);
                        if (p != null && p.isOnline() && (finalCount = (permissionFilteredEntities = typeFilteredEntities.stream().filter(entity -> entity.isValid() && !entity.hasPermission("fixlag.overload.exempt")).collect(Collectors.toList())).size()) > this.criticalEntityCount) {
                            String message = String.valueOf(ChatColor.RED) + "Warning! High number of targeted entities (" + finalCount + ") detected near player " + p.getName() + ".";
                            for (Player staff : Bukkit.getOnlinePlayers()) {
                                if (!staff.isOnline() || !staff.isOp() && !staff.hasPermission("fixlag.overload.notify")) continue;
                                staff.sendMessage(message);
                            }
                        }
                    });
                });
            }
        }, delayTicks, periodTicks);
    }

    public void stopChecking() {
        if (this.checkTask != null && !this.checkTask.isCancelled()) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
    }
}

