/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.not_thefirst.story_mode_clouds.gui.ColorPreviewBox;
import net.not_thefirst.story_mode_clouds.gui.GUIUtils;
import net.not_thefirst.story_mode_clouds.gui.NumericInputField;
import net.not_thefirst.story_mode_clouds.gui.ScrollArea;
import net.not_thefirst.story_mode_clouds.gui.SimpleSliderButton;
import net.not_thefirst.story_mode_clouds.gui.ToggleButton;

public class SimpleConfigScreen
extends class_437 {
    private final class_437 parent;
    private final List<Runnable> onCloseActions = new ArrayList<Runnable>();
    private ScrollArea area;

    public SimpleConfigScreen(class_437 parent, String titleKey) {
        super((class_2561)new class_2588(titleKey));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.area = new ScrollArea(40, 40, this.field_22789 - 80, this.field_22790 - 80);
        this.method_25411(this.area);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20, (class_2561)new class_2588("cloud_tweaks.done"), btn -> {
            this.area.commitAll();
            this.onCloseActions.forEach(Runnable::run);
            this.field_22787.method_1507(this.parent);
        }));
    }

    public void addToggle(String labelKey, boolean initial, Consumer<Boolean> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int buttonWidth = 100;
            int labelWidth = rowWidth - buttonWidth - 6;
            this.area.addLabel((class_2561)new class_2588(labelKey), rowX, rowY + 6, 0xFFFFFF);
            ToggleButton toggle = new ToggleButton(rowX + labelWidth + 6, rowY, buttonWidth, 20, initial, onChange);
            this.area.addWidget(toggle);
        });
    }

    public void addSliderWithBox(String labelKey, double initial, double min, double max, double step, Consumer<Double> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int boxWidth = 55;
            int gap = 6;
            int labelWidth = this.field_22793.method_1727(labelKey) + 4;
            int sliderWidth = rowWidth - labelWidth - boxWidth - 2 * gap;
            this.area.addLabel((class_2561)new class_2588(labelKey), rowX, rowY + 6, 0xFFFFFF);
            SimpleSliderButton slider = new SimpleSliderButton(rowX + labelWidth + gap, rowY, sliderWidth, 20, "", initial, min, max, step, onChange);
            NumericInputField box = new NumericInputField(rowX + rowWidth - boxWidth, rowY, boxWidth, 20, initial, min, max, step, val -> onChange.accept((Double)val));
            slider.onChange = slider.onChange.andThen(val -> box.method_1852(String.format("%.2f", val)));
            box.onChange = box.onChange.andThen(val -> slider.setRealValue((double)val));
            this.area.addWidget((class_339)slider);
            this.area.addWidget((class_339)box);
            this.area.registerCommit(box::commit);
        });
    }

    public void addSlider(String labelKey, double initial, double min, double max, double step, Consumer<Double> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int labelWidth = this.field_22793.method_1727(labelKey) + 4;
            int sliderWidth = rowWidth - labelWidth - 6;
            this.area.addLabel((class_2561)new class_2588(labelKey), rowX, rowY + 6, 0xFFFFFF);
            this.area.addWidget((class_339)new SimpleSliderButton(rowX + labelWidth + 6, rowY, sliderWidth, 20, "", initial, min, max, step, onChange));
        });
    }

    public void onCloseSave(Runnable saveAction) {
        this.onCloseActions.add(saveAction);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        this.method_25420(poseStack);
        GUIUtils.DrawCenteredString(poseStack, this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
        super.method_25394(poseStack, mouseX, mouseY, delta);
    }

    public void addCategory(String textKey, HorizontalAlignment alignment) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int labelX;
            int yOffset = 6;
            switch (alignment) {
                case LEFT: {
                    labelX = rowX;
                    break;
                }
                case CENTER: {
                    labelX = rowX + rowWidth / 2 - class_310.method_1551().field_1772.method_1727(textKey) / 2;
                    break;
                }
                case RIGHT: {
                    labelX = rowX + rowWidth - class_310.method_1551().field_1772.method_1727(textKey);
                    break;
                }
                default: {
                    labelX = rowX;
                }
            }
            this.area.addLabel((class_2561)new class_2588(textKey), labelX, rowY + yOffset, 0xFFFFFF);
        });
    }

    public void addColorPicker(String labelKey, int initialColor, Consumer<Integer> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            SimpleSliderButton bSlider;
            SimpleSliderButton gSlider;
            SimpleSliderButton rSlider;
            int gap = 6;
            int previewSize = 20;
            int sliderWidth = (rowWidth - previewSize - 3 * gap) / 3;
            int r = initialColor >> 16 & 0xFF;
            int g = initialColor >> 8 & 0xFF;
            int b = initialColor & 0xFF;
            ColorPreviewBox preview = new ColorPreviewBox(rowX, rowY, previewSize, previewSize, initialColor);
            this.area.addWidget(preview);
            SimpleSliderButton[] rSliderHolder = new SimpleSliderButton[1];
            SimpleSliderButton[] gSliderHolder = new SimpleSliderButton[1];
            SimpleSliderButton[] bSliderHolder = new SimpleSliderButton[1];
            Consumer<Double> updateColor = val -> {
                int newColor = (int)rSliderHolder[0].getRealValue() << 16 | (int)gSliderHolder[0].getRealValue() << 8 | (int)bSliderHolder[0].getRealValue();
                preview.setColor(newColor);
                onChange.accept(newColor);
            };
            rSliderHolder[0] = rSlider = new SimpleSliderButton(rowX + previewSize + gap, rowY, sliderWidth, 20, "R", r, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)rSlider);
            gSliderHolder[0] = gSlider = new SimpleSliderButton(rowX + previewSize + 2 * gap + sliderWidth, rowY, sliderWidth, 20, "G", g, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)gSlider);
            bSliderHolder[0] = bSlider = new SimpleSliderButton(rowX + previewSize + 3 * gap + 2 * sliderWidth, rowY, sliderWidth, 20, "B", b, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)bSlider);
        });
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

