/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.gui;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3532;

public class NumericInputField
extends class_342 {
    private final double min;
    private final double max;
    private final double step;
    public Consumer<Double> onChange;
    private Double lastValidValue;

    public NumericInputField(int x, int y, int width, int height, double initialValue, double min, double max, double step, Consumer<Double> onChange) {
        super(class_310.method_1551().field_1772, x, y, width, height, (class_2561)new class_2588(""));
        this.min = min;
        this.max = max;
        this.step = step;
        this.onChange = onChange;
        double clamped = this.clampStep(initialValue);
        this.lastValidValue = clamped;
        super.method_1852(this.format(clamped));
    }

    private double parseValue(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return this.lastValidValue != null ? this.lastValidValue : this.min;
        }
    }

    private double clampStep(double val) {
        double clamped = class_3532.method_15350((double)val, (double)this.min, (double)this.max);
        if (this.step > 0.0) {
            clamped = (double)Math.round(clamped / this.step) * this.step;
        }
        return clamped;
    }

    private String format(double val) {
        return String.format("%.2f", val);
    }

    private void updateValue() {
        String text = this.method_1882();
        if (text == null || text.isEmpty() || "-".equals(text) || text.endsWith(".")) {
            return;
        }
        double parsed = this.clampStep(this.parseValue(text));
        if (!Objects.equals(parsed, this.lastValidValue)) {
            this.lastValidValue = parsed;
            this.onChange.accept(parsed);
        }
    }

    public void method_1867(String text) {
        super.method_1867(text);
        this.updateValue();
    }

    public void method_1852(String text) {
        super.method_1852(text);
        this.updateValue();
    }

    public void commit() {
        double parsed = this.clampStep(this.parseValue(this.method_1882()));
        this.lastValidValue = parsed;
        super.method_1852(this.format(parsed));
        this.onChange.accept(parsed);
    }

    public void method_25365(boolean focused) {
        boolean was = this.method_25370();
        super.method_25365(focused);
        if (was && !focused) {
            this.commit();
        }
    }
}

