/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.not_thefirst.story_mode_clouds.gui.AbstractScrollWidget;
import net.not_thefirst.story_mode_clouds.gui.GUIUtils;
import net.not_thefirst.story_mode_clouds.gui.NumericInputField;
import org.lwjgl.opengl.GL11;

public class ScrollArea
extends AbstractScrollWidget {
    private final List<class_339> children = new ArrayList<class_339>();
    private final List<LabelEntry> labels = new ArrayList<LabelEntry>();
    private final List<Runnable> commits = new ArrayList<Runnable>();
    private int nextRowY = 5;
    private final int rowSpacing = 24;
    private final int paddingX = 10;
    private class_339 focusedChild = null;

    public ScrollArea(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)new class_2588(""));
    }

    private double toLocalY(double globalY) {
        return globalY + this.scrollRate();
    }

    public void addRow(RowBuilder builder) {
        int rowX = this.field_22760 + 10;
        int rowY = this.field_22761 + this.nextRowY;
        int rowWidth = this.field_22758 - 20;
        builder.build(rowX, rowY, rowWidth);
        this.nextRowY += 24;
    }

    public void addLabel(class_2561 text, int x, int y, int color) {
        this.labels.add(new LabelEntry(text, x, y, color));
    }

    public void addWidget(class_339 widget) {
        this.children.add(widget);
    }

    public void registerCommit(Runnable commit) {
        this.commits.add(commit);
    }

    public void commitAll() {
        this.commits.forEach(Runnable::run);
    }

    @Override
    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_22764) {
            return;
        }
        ScrollArea.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)-14671840);
        ScrollArea.enableScissor(this.field_22760, this.field_22761, this.field_22758, this.field_22759);
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)(-this.scrollAmount), 0.0);
        for (LabelEntry lbl : this.labels) {
            GUIUtils.DrawTextShadowed(poseStack, lbl.text, lbl.x, lbl.y, lbl.color);
        }
        for (class_339 w : this.children) {
            w.method_25394(poseStack, mouseX, mouseY + this.scrollAmount, partialTicks);
        }
        poseStack.method_22909();
        ScrollArea.disableScissor();
        if (this.scrollbarVisible()) {
            int barHeight = this.getScrollBarHeight();
            int barTop = (int)((double)this.scrollAmount * (double)(this.field_22759 - barHeight) / (double)this.getMaxScrollAmount()) + this.field_22761;
            ScrollArea.method_25294((class_4587)poseStack, (int)(this.field_22760 + this.field_22758 - 6), (int)barTop, (int)(this.field_22760 + this.field_22758 - 2), (int)(barTop + barHeight), (int)-5592406);
        }
    }

    private static void enableScissor(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        double scale = mc.method_22683().method_4495();
        int fbHeight = mc.method_22683().method_4506();
        int scissorX = (int)((double)x * scale);
        int scissorY = (int)((double)(mc.method_22683().method_4502() - (y + h)) * scale);
        int scissorW = (int)((double)w * scale);
        int scissorH = (int)((double)h * scale);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
    }

    private static void disableScissor() {
        GL11.glDisable((int)3089);
    }

    @Override
    public boolean method_25402(double mx, double my, int btn) {
        if (!this.method_25405(mx, my)) {
            return false;
        }
        double localY = my + (double)this.scrollAmount;
        for (class_339 w : this.children) {
            if (!w.method_25402(mx, localY, btn)) continue;
            if (this.focusedChild != null) {
                this.focusedChild.method_25407(false);
            }
            this.focusedChild = w;
            this.focusedChild.method_25407(true);
            return true;
        }
        return super.method_25402(mx, my, btn);
    }

    @Override
    public boolean method_25406(double mx, double my, int btn) {
        if (!this.method_25405(mx, my)) {
            return false;
        }
        double localY = my + (double)this.scrollAmount;
        boolean consumed = false;
        for (class_339 w : this.children) {
            if (!w.method_25406(mx, localY, btn)) continue;
            consumed = true;
        }
        if (this.focusedChild != null && !(this.focusedChild instanceof NumericInputField)) {
            this.focusedChild.method_25407(false);
            this.focusedChild = null;
        }
        return consumed || super.method_25406(mx, my, btn);
    }

    @Override
    public boolean method_25403(double mx, double my, int btn, double dx, double dy) {
        if (!this.method_25405(mx, my)) {
            return false;
        }
        double localY = my + (double)this.scrollAmount;
        boolean consumed = false;
        for (class_339 w : this.children) {
            if (!w.method_25403(mx, localY, btn, dx, dy)) continue;
            consumed = true;
        }
        return consumed || super.method_25403(mx, my, btn, dx, dy);
    }

    public boolean method_25404(int key, int scancode, int mods) {
        if (this.focusedChild != null) {
            boolean consumed = this.focusedChild.method_25404(key, scancode, mods);
            if (key == 257 || key == 335) {
                if (this.focusedChild instanceof NumericInputField) {
                    NumericInputField numeric = (NumericInputField)this.focusedChild;
                    numeric.commit();
                }
                this.focusedChild.method_25407(false);
                this.focusedChild = null;
                return true;
            }
            return consumed;
        }
        return super.method_25404(key, scancode, mods);
    }

    public boolean method_25400(char chr, int mods) {
        if (this.focusedChild != null && this.focusedChild.method_25400(chr, mods)) {
            return true;
        }
        return super.method_25400(chr, mods);
    }

    protected int contentHeight() {
        return this.nextRowY + 5;
    }

    @Override
    protected double scrollRate() {
        return 12.0;
    }

    @Override
    protected int getContentHeight() {
        return this.contentHeight();
    }

    @Override
    protected void renderContents(class_4587 poseStack, int mouseX, int mouseY, float partialTicks, int scrollY) {
        for (LabelEntry lbl : this.labels) {
            class_310.method_1551().field_1772.method_30883(poseStack, lbl.text, (float)lbl.x, (float)lbl.y, lbl.color);
        }
        for (class_339 w : this.children) {
            w.method_25394(poseStack, mouseX, mouseY + scrollY, partialTicks);
        }
    }

    @FunctionalInterface
    public static interface RowBuilder {
        public void build(int var1, int var2, int var3);
    }

    private class LabelEntry {
        public class_2561 text;
        public int x;
        public int y;
        public int color;

        public LabelEntry(class_2561 text, int x, int y, int color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.color = color;
        }
    }
}

