/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.gui;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class SimpleSliderButton
extends class_357 {
    private final double min;
    private final double max;
    private final double step;
    private final String label;
    public Consumer<Double> onChange;

    public SimpleSliderButton(int x, int y, int width, int height, String label, double initialValue, double min, double max, double step, Consumer<Double> onChange) {
        super(x, y, width, height, (class_2561)new class_2588(""), SimpleSliderButton.clamp01((initialValue - min) / (max - min)));
        this.label = label;
        this.min = min;
        this.max = max;
        this.step = step;
        this.onChange = onChange;
        this.method_25346();
    }

    private static double clamp01(double v) {
        return class_3532.method_15350((double)v, (double)0.0, (double)1.0);
    }

    private static double snap(double v, double min, double max, double step) {
        double c = class_3532.method_15350((double)v, (double)min, (double)max);
        if (step > 0.0) {
            c = (double)Math.round(c / step) * step;
        }
        return c;
    }

    private double toReal(double slider01) {
        return SimpleSliderButton.snap(this.min + slider01 * (this.max - this.min), this.min, this.max, this.step);
    }

    private double to01(double real) {
        return SimpleSliderButton.clamp01((SimpleSliderButton.snap(real, this.min, this.max, this.step) - this.min) / (this.max - this.min));
    }

    public double getRealValue() {
        return this.toReal(this.field_22753);
    }

    protected void method_25346() {
        double val = this.getRealValue();
        this.method_25355(class_2561.method_30163((String)(this.label + ": " + String.format("%.2f", val))));
    }

    protected void method_25344() {
        double real = this.getRealValue();
        this.field_22753 = this.to01(real);
        this.onChange.accept(real);
    }

    public void setRealValue(double realValue) {
        double snapped = SimpleSliderButton.snap(realValue, this.min, this.max, this.step);
        this.field_22753 = this.to01(snapped);
        this.method_25346();
        this.onChange.accept(snapped);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.field_22763 && (this.method_25367() || this.method_25370())) {
            double sliderPos = (mouseX - (double)(this.field_22760 + 4)) / (double)(this.field_22758 - 8);
            this.field_22753 = class_3532.method_15350((double)sliderPos, (double)0.0, (double)1.0);
            this.method_25344();
            this.method_25346();
            return true;
        }
        return false;
    }
}

