/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4063;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshBuilderRegistry;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.utils.Texture;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CustomCloudRenderer {
    protected static final class_2960 TEXTURE_LOCATION = new class_2960("minecraft", "textures/environment/clouds.png");
    @Nullable
    public Optional<Texture.TextureData> currentTexture = Optional.empty();
    private int prevSkyColor = 0;
    private final List<LayerState> layers = new ArrayList<LayerState>();

    public CustomCloudRenderer() {
        this.rebuildLayerStates();
    }

    private void rebuildLayerStates() {
        int i;
        this.layers.clear();
        int layerCount = CloudsConfiguration.INSTANCE.getLayerCount();
        for (i = 0; i < layerCount; ++i) {
            LayerState layerState = new LayerState();
            layerState.texture = null;
            layerState.needsRebuild = true;
            layerState.prevCellX = Integer.MIN_VALUE;
            layerState.prevCellZ = Integer.MIN_VALUE;
            layerState.prevPos = RelativeCameraPos.INSIDE_CLOUDS;
            layerState.prevStatus = null;
            layerState.lastFadeRebuildMs = System.currentTimeMillis();
            this.layers.add(layerState);
        }
        for (i = 0; i < layerCount; ++i) {
            LayerState layer = this.layers.get(i);
            CloudsConfiguration.LayerConfiguration layerConfig = CloudsConfiguration.INSTANCE.getLayer(i);
            layer.offsetX = layerConfig.LAYER_OFFSET_X;
            layer.offsetZ = layerConfig.LAYER_OFFSET_Z;
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<Texture.TextureData> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long packCellData(int color, boolean north, boolean east, boolean south, boolean west) {
        return (long)color << 4 | (long)((north ? 1 : 0) << 3) | (long)((east ? 1 : 0) << 2) | (long)((south ? 1 : 0) << 1) | (long)(west ? 1 : 0);
    }

    public void apply(Optional<Texture.TextureData> optional, class_3300 resourceManager, class_3695 profilerFiller) {
        Texture.TextureData baseTexture = optional.orElse(this.prepare(resourceManager, profilerFiller).orElse(null));
        for (LayerState layer : this.layers) {
            layer.texture = this.resolveTextureForLayer(layer, baseTexture);
            layer.needsRebuild = true;
        }
    }

    @Nullable
    private Texture.TextureData resolveTextureForLayer(LayerState layer, @Nullable Texture.TextureData fallback) {
        return fallback;
    }

    private void applyTexture() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        if (!this.currentTexture.isPresent()) {
            this.prepare(client.method_1478(), client.method_16011());
        }
        this.apply(this.currentTexture, client.method_1478(), client.method_16011());
    }

    public void render(int cloudColor, class_4063 status, float cloudHeight, class_243 cam, float tickDelta, class_4587 poseStack) {
        double dx = cam.field_1352 + (double)(tickDelta * 0.03f);
        double dz = cam.field_1350 + (double)3.96f;
        int activeLayers = CloudsConfiguration.INSTANCE.getLayerCount();
        if (activeLayers < 0) {
            return;
        }
        if (activeLayers != this.layers.size()) {
            this.rebuildLayerStates();
            this.applyTexture();
        }
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < activeLayers; ++i) {
            order.add(i);
        }
        order.sort((a, b) -> {
            float ya = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)a.intValue()).LAYER_HEIGHT - cam.field_1351);
            float yb = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)b.intValue()).LAYER_HEIGHT - cam.field_1351);
            return Float.compare(Math.abs(yb), Math.abs(ya));
        });
        RenderSystem.disableTexture();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.shadeModel((int)7425);
        RenderSystem.depthMask((boolean)true);
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            Texture.TextureData tex;
            int layer = (Integer)iterator.next();
            LayerState currentLayer = this.layers.get(layer);
            CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(layer);
            if (!layerConfiguration.LAYER_RENDERED || (tex = currentLayer.texture) == null) continue;
            double wrapX = (float)tex.width * 12.0f;
            double wrapZ = (float)tex.height * 12.0f;
            double dxLayer = dx + (double)currentLayer.offsetX;
            double dzLayer = dz + (double)currentLayer.offsetZ;
            dxLayer -= (double)class_3532.method_15357((double)(dxLayer / wrapX)) * wrapX;
            dzLayer -= (double)class_3532.method_15357((double)(dzLayer / wrapZ)) * wrapZ;
            float layerY = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)layer).LAYER_HEIGHT - cam.field_1351);
            float cloudChunkHeight = 4.0f * (layerConfiguration.IS_ENABLED ? layerConfiguration.CLOUD_Y_SCALE : 1.0f);
            float relYTop = layerY + cloudChunkHeight;
            RelativeCameraPos layerPos = relYTop < 0.0f ? RelativeCameraPos.ABOVE_CLOUDS : (layerY > 0.0f ? RelativeCameraPos.BELOW_CLOUDS : RelativeCameraPos.INSIDE_CLOUDS);
            int cellX = class_3532.method_15357((double)(dxLayer / 12.0));
            int cellZ = class_3532.method_15357((double)(dzLayer / 12.0));
            float offX = (float)(dxLayer - (double)((float)cellX * 12.0f));
            float offZ = (float)(dzLayer - (double)((float)cellZ * 12.0f));
            long now = System.currentTimeMillis();
            float relY = relYTop - cloudChunkHeight / 2.0f;
            if (layerConfiguration.IS_ENABLED && layerConfiguration.FADE_ENABLED && Math.abs(relY) <= layerConfiguration.TRANSITION_RANGE && now - currentLayer.lastFadeRebuildMs > 40L) {
                currentLayer.needsRebuild = true;
                currentLayer.lastFadeRebuildMs = now;
            }
            if (layerConfiguration.IS_ENABLED && layerConfiguration.CUSTOM_BRIGHTNESS && cloudColor != this.prevSkyColor) {
                currentLayer.needsRebuild = true;
                if (layer == 0) {
                    this.prevSkyColor = cloudColor;
                }
            }
            if (currentLayer.needsRebuild || cellX != currentLayer.prevCellX || cellZ != currentLayer.prevCellZ || layerPos != currentLayer.prevPos || status != currentLayer.prevStatus || cloudColor != this.prevSkyColor) {
                currentLayer.needsRebuild = false;
                currentLayer.prevCellX = cellX;
                currentLayer.prevCellZ = cellZ;
                currentLayer.prevPos = layerPos;
                currentLayer.prevStatus = status;
                currentLayer.currentStatus = status;
                this.prevSkyColor = cloudColor;
                if (currentLayer.buffer != null) {
                    currentLayer.buffer.close();
                }
                currentLayer.buffer = new class_291(class_290.field_1576);
                class_287 mesh = this.buildMeshForLayer(tex, class_289.method_1348(), cellX, cellZ, status, layerPos, relY, layer, cloudColor, offX, offZ);
                if (mesh != null) {
                    currentLayer.buffer.method_1352(mesh);
                    currentLayer.bufferEmpty = false;
                } else {
                    currentLayer.bufferEmpty = true;
                }
            }
            poseStack.method_22903();
            poseStack.method_22904((double)(-offX), (double)layerY, (double)(-offZ));
            if (!currentLayer.bufferEmpty) {
                float CUSTOM_BRIGHTNESS = layerConfiguration.BRIGHTNESS;
                if (layerConfiguration.CUSTOM_BRIGHTNESS && layerConfiguration.IS_ENABLED) {
                    RenderSystem.color4f((float)CUSTOM_BRIGHTNESS, (float)CUSTOM_BRIGHTNESS, (float)CUSTOM_BRIGHTNESS, (float)1.0f);
                }
                if (!layerConfiguration.FOG_ENABLED) {
                    RenderSystem.disableFog();
                }
                currentLayer.buffer.method_1353();
                RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.drawWithRenderType(offX, layerY, offZ, currentLayer.buffer, poseStack);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.drawWithRenderType(offX, layerY, offZ, currentLayer.buffer, poseStack);
                class_291.method_1354();
                RenderSystem.enableFog();
            }
            poseStack.method_22909();
        }
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.shadeModel((int)7424);
    }

    private void drawWithRenderType(float ox, float oy, float oz, class_291 buf, class_4587 poseStack) {
        class_290.field_1576.method_22649(0L);
        buf.method_1351(poseStack.method_23760().method_23761(), 7);
        class_290.field_1576.method_22651();
    }

    @Nullable
    private class_287 buildMeshForLayer(Texture.TextureData tex, class_289 tess, int cx, int cz, class_4063 status, RelativeCameraPos pos, float relY, int currentLayer, int skyColor, float offX, float offZ) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        LayerState state = this.layers.get(currentLayer);
        class_287 bb = tess.method_1349();
        bb.method_1328(7, class_290.field_1576);
        MeshTypeBuilder builder = MeshBuilderRegistry.getBuilder(layerConfiguration.MODE.name());
        builder.Build(bb, tex, pos, state, cx, cz, relY, currentLayer, skyColor, offX, offZ);
        bb.method_1326();
        return bb;
    }

    public void markForRebuild(int layer) {
        if (layer >= 0 && layer < this.layers.size()) {
            this.layers.get((int)layer).needsRebuild = true;
        }
    }

    public void markForRebuild() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get((int)i).needsRebuild = true;
        }
    }

    public void close() {
        for (LayerState layer : this.layers) {
            if (layer.buffer == null) continue;
            layer.buffer.close();
        }
    }

    public class LayerState {
        public int index;
        public float offsetX;
        public float offsetZ;
        public Texture.TextureData texture;
        public class_291 buffer;
        public int indexCount;
        public boolean needsRebuild;
        public int prevCellX;
        public int prevCellZ;
        public RelativeCameraPos prevPos;
        public class_4063 prevStatus;
        public class_4063 currentStatus;
        public long lastFadeRebuildMs;
        public float prevFadeMix;
        public boolean bufferEmpty;

        public LayerState(int index) {
            this.index = index;
        }

        public LayerState() {
            this(-1);
        }
    }

    public static enum RelativeCameraPos {
        ABOVE_CLOUDS,
        INSIDE_CLOUDS,
        BELOW_CLOUDS;

    }

    public static enum CloudMode {
        NORMAL,
        POPULATED;

    }
}

