/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_761;
import net.not_thefirst.story_mode_clouds.api.ClothConfigScreen;
import net.not_thefirst.story_mode_clouds.compat.Compat;
import net.not_thefirst.story_mode_clouds.config.CloudsConfigScreen;

@Environment(value=EnvType.CLIENT)
public class CloudsConfiguration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cloud_configs.json");
    public boolean IS_ENABLED = true;
    public boolean CLOUDS_RENDERED = true;
    public boolean APPEARS_SHADED = false;
    public boolean USES_CUSTOM_ALPHA = true;
    public boolean CUSTOM_BRIGHTNESS = true;
    public boolean USES_CUSTOM_COLOR = false;
    public boolean DEBUG_v0 = true;
    public boolean RANDOMIZED_Y = true;
    public boolean FADE_ENABLED = true;
    public boolean FOG_ENABLED = true;
    public float FADE_ALPHA = 0.2f;
    public float CLOUD_Y_SCALE = 1.5f;
    public float BRIGHTNESS = 1.0f;
    public float BASE_ALPHA = 0.8f;
    public float TRANSITION_RANGE = 10.0f;
    public int CLOUD_COLOR = 0xFFFFFF;
    public int[] CLOUD_COLORS = new int[MAX_LAYER_COUNT];
    public int CLOUD_LAYERS = 1;
    public float CLOUD_LAYERS_SPACING = 14.0f;
    public boolean CLOUD_RANDOM_LAYERS = true;
    public static int MAX_LAYER_COUNT = 10;
    private static CloudsConfiguration INSTANCE = new CloudsConfiguration();

    CloudsConfiguration() {
        Arrays.fill(this.CLOUD_COLORS, 0xFFFFFF);
    }

    public static CloudsConfiguration get() {
        return INSTANCE;
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            CloudsConfiguration.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (CloudsConfiguration)GSON.fromJson((Reader)reader, CloudsConfiguration.class);
            if (CloudsConfiguration.INSTANCE.CLOUD_COLORS == null || CloudsConfiguration.INSTANCE.CLOUD_COLORS.length < MAX_LAYER_COUNT) {
                int[] newArr = new int[MAX_LAYER_COUNT];
                Arrays.fill(newArr, 0xFFFFFF);
                if (CloudsConfiguration.INSTANCE.CLOUD_COLORS != null) {
                    System.arraycopy(CloudsConfiguration.INSTANCE.CLOUD_COLORS, 0, newArr, 0, CloudsConfiguration.INSTANCE.CLOUD_COLORS.length);
                }
                CloudsConfiguration.INSTANCE.CLOUD_COLORS = newArr;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        class_310 client = class_310.method_1551();
        class_761 renderer = client.field_1769;
        if (renderer != null && renderer.method_62196() != null) {
            renderer.method_62196().method_62166();
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class_437 createConfigScreen(class_437 parent) {
        if (Compat.hasClothConfig()) {
            return ClothConfigScreen.create(parent);
        }
        return new CloudsConfigScreen(parent);
    }
}

