/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11285;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4063;
import net.minecraft.class_9848;
import net.minecraft.class_9955;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.ModRenderPipelines;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class CustomCloudRenderer
extends class_9955 {
    private static final float CELL_SIZE = 12.0f;
    private static final float HEIGHT = 4.0f;
    private static final int UBO_SIZE = new Std140SizeCalculator().putVec4().putVec4().putVec4().putFloat().putFloat().putFloat().putFloat().putFloat().putInt().putInt().putFloat().get();
    private final LayerState[] layers;
    private final int maxLayers = CloudsConfiguration.MAX_LAYER_COUNT;
    @Nullable
    private class_9955.class_9957 baseTexture;

    public CustomCloudRenderer() {
        this.layers = new LayerState[this.maxLayers];
        Random rand = CloudsConfiguration.get().CLOUD_RANDOM_LAYERS ? new Random(12648430L) : null;
        for (int i = 0; i < this.maxLayers; ++i) {
            this.layers[i] = new LayerState(rand != null ? rand.nextFloat() * 12.0f * 64.0f : 0.0f, rand != null ? rand.nextFloat() * 12.0f * 64.0f : 0.0f, i);
        }
    }

    protected Optional<class_9955.class_9957> method_62171(class_3300 resourceManager, class_3695 profilerFiller) {
        return super.method_62171(resourceManager, profilerFiller);
    }

    protected void method_62177(Optional<class_9955.class_9957> optional, class_3300 resourceManager, class_3695 profilerFiller) {
        this.baseTexture = optional.orElse(null);
        for (LayerState layer : this.layers) {
            layer.texture = this.baseTexture;
            layer.needsRebuild = true;
        }
    }

    public void method_62168(int skyColor, class_4063 status, float cloudHeight, class_243 cam, float tickDelta) {
        int activeLayers = class_3532.method_15340((int)CloudsConfiguration.get().CLOUD_LAYERS, (int)0, (int)this.maxLayers);
        if (activeLayers <= 0 || this.baseTexture == null) {
            return;
        }
        boolean fancy = status == class_4063.field_18164;
        int radius = class_3532.method_15386((float)((float)(Math.min((Integer)class_310.method_1551().field_1690.method_71270().method_41753(), 128) * 16) / 12.0f));
        for (int i = 0; i < activeLayers; ++i) {
            this.layers[i].ensureUTB(radius);
        }
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < activeLayers; ++i) {
            order.add(i);
        }
        order.sort((a, b) -> {
            float ya = (float)((double)cloudHeight - cam.field_1351) + (float)a.intValue() * CloudsConfiguration.get().CLOUD_LAYERS_SPACING;
            float yb = (float)((double)cloudHeight - cam.field_1351) + (float)b.intValue() * CloudsConfiguration.get().CLOUD_LAYERS_SPACING;
            return Float.compare(Math.abs(yb), Math.abs(ya));
        });
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            this.renderLayer(idx, skyColor, class_310.method_1551().field_1687.method_8597().comp_4037().orElse(192).intValue(), cam, fancy, status, radius, tickDelta);
        }
    }

    private void renderLayer(int idx, int skyColor, float cloudHeight, class_243 cam, boolean fancy, class_4063 status, int radius, float dt) {
        boolean rebuild;
        LayerState layer = this.layers[idx];
        class_9955.class_9957 tex = layer.texture;
        if (tex == null) {
            return;
        }
        double worldX = cam.field_1352 + (double)(dt * 0.03f);
        double worldZ = cam.field_1350 + (double)3.96f;
        double wrapX = (float)tex.comp_3007() * 12.0f;
        double wrapZ = (float)tex.comp_3008() * 12.0f;
        double normOffX = ((double)layer.offsetX % wrapX + wrapX) % wrapX;
        double normOffZ = ((double)layer.offsetZ % wrapZ + wrapZ) % wrapZ;
        double dx = (worldX += normOffX) - (double)class_3532.method_15357((double)(worldX / wrapX)) * wrapX;
        double dz = (worldZ += normOffZ) - (double)class_3532.method_15357((double)(worldZ / wrapZ)) * wrapZ;
        int cellX = class_3532.method_15357((double)(dx / 12.0));
        int cellZ = class_3532.method_15357((double)(dz / 12.0));
        float offX = (float)(dx - (double)((float)cellX * 12.0f));
        float offZ = (float)(dz - (double)((float)cellZ * 12.0f));
        float layerY = cloudHeight + (float)idx * CloudsConfiguration.get().CLOUD_LAYERS_SPACING;
        float relY = layerY - (float)cam.field_1351;
        RelativeCameraPos pos = this.computeRelativePos(relY, 4.0f);
        boolean bl = rebuild = layer.needsRebuild || cellX != layer.prevCellX || cellZ != layer.prevCellZ || pos != layer.prevRelativePos || status != layer.prevStatus;
        if (rebuild) {
            this.rebuildLayer(layer, tex, cellX, cellZ, pos, status, idx, radius);
        }
        if (layer.quadCount > 0) {
            this.writeUBO(layer, offX, offZ, skyColor, relY, relY);
            this.drawLayer(layer, layer.quadCount, fancy);
        }
    }

    private void rebuildLayer(LayerState layer, class_9955.class_9957 tex, int cellX, int cellZ, RelativeCameraPos pos, class_4063 status, int layerIdx, int radius) {
        layer.ensureUTB(radius);
        layer.utb.method_71121();
        try (GpuBuffer.MappedView mapped = RenderSystem.getDevice().createCommandEncoder().mapBuffer(layer.utb.method_71119(), false, true);){
            this.buildMeshForLayer(tex, mapped.data(), cellX, cellZ, status, pos, layerIdx, radius);
            layer.quadCount = mapped.data().position() / 3;
        }
        layer.prevCellX = cellX;
        layer.prevCellZ = cellZ;
        layer.prevRelativePos = pos;
        layer.prevStatus = status;
        layer.needsRebuild = false;
    }

    private void buildMeshForLayer(class_9955.class_9957 tex, ByteBuffer buf, int baseCellX, int baseCellZ, class_4063 status, RelativeCameraPos pos, int layerIdx, int radius) {
        if (tex == null) {
            return;
        }
        long[] cells = tex.comp_3006();
        int width = tex.comp_3007();
        int height = tex.comp_3008();
        for (int n = 0; n <= 2 * radius; ++n) {
            for (int o = -n; o <= n; ++o) {
                int p = n - Math.abs(o);
                if (p < 0 || p > radius || o * o + p * p > radius * radius) continue;
                if (p != 0) {
                    this.tryBuildCell(pos, buf, baseCellX, baseCellZ, o, -p, status, width, height, cells);
                }
                this.tryBuildCell(pos, buf, baseCellX, baseCellZ, o, p, status, width, height, cells);
            }
        }
    }

    private void tryBuildCell(RelativeCameraPos pos, ByteBuffer buf, int baseCellX, int baseCellZ, int offsetX, int offsetZ, class_4063 fancy, int texWidth, int texHeight, long[] cells) {
        int cellZ;
        int cellX = Math.floorMod(baseCellX + offsetX, texWidth);
        long cellData = cells[cellX + (cellZ = Math.floorMod(baseCellZ + offsetZ, texHeight)) * texWidth];
        if (cellData == 0L) {
            return;
        }
        if (fancy == class_4063.field_18164) {
            this.buildExtrudedCell(pos, buf, offsetX, offsetZ, cellData);
        } else {
            this.buildFlatCell(buf, offsetX, offsetZ);
        }
    }

    private void buildFlatCell(ByteBuffer buf, int x, int z) {
        this.encodeFace(buf, x, z, class_2350.field_11033, 32);
    }

    private static boolean isNorthEmpty(long l) {
        return (l >> 3 & 1L) != 0L;
    }

    private static boolean isEastEmpty(long l) {
        return (l >> 2 & 1L) != 0L;
    }

    private static boolean isSouthEmpty(long l) {
        return (l >> 1 & 1L) != 0L;
    }

    private static boolean isWestEmpty(long l) {
        return (l >> 0 & 1L) != 0L;
    }

    private void buildExtrudedCell(RelativeCameraPos pos, ByteBuffer buf, int x, int z, long cellData) {
        boolean inner;
        if (pos != RelativeCameraPos.BELOW_CLOUDS) {
            this.encodeFace(buf, x, z, class_2350.field_11036, 0);
        }
        if (pos != RelativeCameraPos.ABOVE_CLOUDS) {
            this.encodeFace(buf, x, z, class_2350.field_11033, 0);
        }
        if (CustomCloudRenderer.isNorthEmpty(cellData) && z > 0) {
            this.encodeFace(buf, x, z, class_2350.field_11043, 0);
        }
        if (CustomCloudRenderer.isSouthEmpty(cellData) && z < 0) {
            this.encodeFace(buf, x, z, class_2350.field_11035, 0);
        }
        if (CustomCloudRenderer.isWestEmpty(cellData) && x > 0) {
            this.encodeFace(buf, x, z, class_2350.field_11039, 0);
        }
        if (CustomCloudRenderer.isEastEmpty(cellData) && x < 0) {
            this.encodeFace(buf, x, z, class_2350.field_11034, 0);
        }
        boolean bl = inner = Math.abs(x) <= 1 && Math.abs(z) <= 1;
        if (inner) {
            for (class_2350 dir : class_2350.values()) {
                this.encodeFace(buf, x, z, dir, 16);
            }
        }
    }

    private void encodeFace(ByteBuffer buf, int x, int z, class_2350 dir, int flag) {
        int encoded = dir.method_10146() | flag;
        encoded |= (x & 1) << 7;
        buf.put((byte)(x >> 1)).put((byte)(z >> 1)).put((byte)(encoded |= (z & 1) << 6));
    }

    private int getConfigFlag(CloudsConfiguration config) {
        int flags = 0;
        if (config.IS_ENABLED) {
            flags |= 1;
        }
        if (config.APPEARS_SHADED) {
            flags |= 2;
        }
        if (config.USES_CUSTOM_ALPHA) {
            flags |= 4;
        }
        if (config.CUSTOM_BRIGHTNESS) {
            flags |= 8;
        }
        if (config.USES_CUSTOM_COLOR) {
            flags |= 0x10;
        }
        if (config.FOG_ENABLED) {
            flags |= 0x20;
        }
        if (config.FADE_ENABLED) {
            flags |= 0x40;
        }
        if (config.RANDOMIZED_Y) {
            flags |= 0x80;
        }
        return flags;
    }

    private void writeUBO(LayerState layer, float offX, float offZ, int skyColor, float y, float relYToCenter) {
        CloudsConfiguration config = CloudsConfiguration.get();
        int appliedColor = !config.IS_ENABLED ? skyColor : (config.USES_CUSTOM_COLOR ? config.CLOUD_COLORS[layer.index] : (config.CUSTOM_BRIGHTNESS ? class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f) : skyColor));
        float cloudChunkHeight = 4.0f * (config.IS_ENABLED ? config.CLOUD_Y_SCALE : 1.0f);
        try (GpuBuffer.MappedView mapped = RenderSystem.getDevice().createCommandEncoder().mapBuffer(layer.ubo.method_71119(), false, true);){
            Std140Builder.intoBuffer((ByteBuffer)mapped.data()).putVec4(class_9848.method_65101((int)appliedColor), class_9848.method_65102((int)appliedColor), class_9848.method_65103((int)appliedColor), 1.0f).putVec4(-offX, y, -offZ, 0.0f).putVec4(12.0f, cloudChunkHeight, 12.0f, 0.0f).putFloat(config.BASE_ALPHA).putFloat(config.FADE_ALPHA).putFloat(config.BRIGHTNESS).putFloat(config.TRANSITION_RANGE).putFloat(config.CLOUD_LAYERS_SPACING).putInt(layer.index).putInt(this.getConfigFlag(config)).putFloat(relYToCenter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawLayer(LayerState layer, int quadCount, boolean fancy) {
        if (quadCount == 0 || layer.utb == null) {
            return;
        }
        RenderSystem.class_5590 indices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer gpuBuffer = indices.method_68274(6 * quadCount);
        class_276 rt = class_310.method_1551().method_1522();
        class_276 ct = class_310.method_1551().field_1769.method_29364();
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuTextureView colorTex = rt.method_71639();
        GpuTextureView depthTex = rt.method_71640();
        if (ct != null) {
            colorTex = ct.method_71639();
            depthTex = ct.method_71640();
        } else {
            colorTex = rt.method_71639();
            depthTex = rt.method_71640();
        }
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Clouds", colorTex, OptionalInt.empty(), depthTex, OptionalDouble.empty());){
            RenderPipeline pipeline = fancy ? ModRenderPipelines.CLOUDS_CUSTOM_PIPELINE : class_10799.field_56830;
            pass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", gpuBufferSlice);
            pass.setUniform("CloudInfo", layer.ubo.method_71119());
            pass.setUniform("CloudFaces", layer.utb.method_71119());
            pass.setIndexBuffer(gpuBuffer, indices.method_31924());
            pass.setVertexBuffer(0, RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(quadCount));
            pass.setPipeline(pipeline);
            pass.drawIndexed(0, 0, 6 * quadCount, 1);
        }
    }

    private RelativeCameraPos computeRelativePos(float baseY, float height) {
        float top = baseY + height;
        if (top < 0.0f) {
            return RelativeCameraPos.ABOVE_CLOUDS;
        }
        if (baseY > 0.0f) {
            return RelativeCameraPos.BELOW_CLOUDS;
        }
        return RelativeCameraPos.INSIDE_CLOUDS;
    }

    private static int computeUTBSize(int radius) {
        int k = (radius + 1) * (radius + 1) * 2;
        return (k * 4 + 54) * 3;
    }

    public void close() {
        for (LayerState layer : this.layers) {
            layer.ubo.close();
            if (layer.utb == null) continue;
            layer.utb.close();
        }
    }

    public void method_71099() {
        for (LayerState layer : this.layers) {
            layer.ubo.method_71121();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class LayerState {
        int index;
        float offsetX;
        float offsetZ;
        int prevCellX = Integer.MIN_VALUE;
        int prevCellZ = Integer.MIN_VALUE;
        RelativeCameraPos prevRelativePos = RelativeCameraPos.INSIDE_CLOUDS;
        class_4063 prevStatus = null;
        boolean needsRebuild = true;
        int quadCount = 0;
        @Nullable
        class_9955.class_9957 texture;
        @Nullable
        class_11285 utb;
        @Nullable
        class_11285 ubo;

        public LayerState(float x, float z, int index) {
            this.offsetX = x;
            this.offsetZ = z;
            this.index = index;
            this.ubo = new class_11285(() -> "Cloud UBO", 130, UBO_SIZE);
        }

        public void ensureUTB(int radius) {
            int size = CustomCloudRenderer.computeUTBSize(radius);
            if (this.utb == null || this.utb.method_71119().size() != size) {
                if (this.utb != null) {
                    this.utb.close();
                }
                this.utb = new class_11285(() -> "Cloud UTB", 258, size);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RelativeCameraPos {
        ABOVE_CLOUDS,
        INSIDE_CLOUDS,
        BELOW_CLOUDS;

    }
}

