/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;

@Config(name="cloud_tweaks")
@Environment(value=EnvType.CLIENT)
public class ClothConfigClass
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public CloudsConfiguration.LayerHolder layers = new CloudsConfiguration.LayerHolder();
    @ConfigEntry.Gui.CollapsibleObject
    public GlobalConfig global = new GlobalConfig();

    public void applyFromMain(CloudsConfiguration config) {
        int needed;
        this.global.applyFromMain(config);
        if (this.layers == null) {
            this.layers = new CloudsConfiguration.LayerHolder();
        }
        int n = needed = config.getHolder() != null ? config.getHolder().layers.size() : 0;
        if (this.layers.layers.size() > needed) {
            while (this.layers.layers.size() > needed) {
                this.layers.layers.remove(this.layers.layers.size() - 1);
            }
        } else {
            int start;
            for (int i = start = this.layers.layers.size(); i < needed; ++i) {
                this.layers.layers.add(new CloudsConfiguration.LayerConfiguration(i));
            }
        }
        for (int i = 0; i < needed; ++i) {
            CloudsConfiguration.LayerConfiguration clothLayer = this.layers.layers.get(i);
            CloudsConfiguration.LayerConfiguration mainLayer = config.getHolder().layers.get(i);
            clothLayer.copy(mainLayer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class GlobalConfig {
        public boolean CLOUDS_RENDERED = true;

        public void applyFromMain(CloudsConfiguration config) {
            this.CLOUDS_RENDERED = config.CLOUDS_RENDERED;
        }
    }
}

