/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer.mesh_builders;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.renderer.MeshBuilder;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.ColorUtils;
import net.not_thefirst.story_mode_clouds.utils.Texture;

@Environment(value=EnvType.CLIENT)
public class PuffMeshBuilder
implements MeshTypeBuilder {
    private static final long PHI = -7046029254386353131L;
    private static final int SPLITMIX_TABLE_SIZE = 1024;
    private static final float[] sinTable = new float[1024];
    private static final float[] cosTable = new float[1024];
    private static final Map<String, LayerCache> LayerCaches;

    private static long splitmix64(long x) {
        x += -7046029254386353131L;
        x = (x ^ x >>> 30) * -4658895280553007687L;
        x = (x ^ x >>> 27) * -7723592293110705685L;
        return x ^ x >>> 31;
    }

    private static float uint64ToFloat01(long v) {
        long top = v >>> 11 & 0x1FFFFFFFFFFFFFL;
        double d = (double)top * (double)1.110223E-16f;
        return (float)d;
    }

    private static LayerCache ensureCache(Texture.TextureData tex, int currentLayer) {
        String key = Integer.toHexString(System.identityHashCode(tex)) + ":" + currentLayer;
        LayerCache cache = LayerCaches.get(key);
        long[] cellsRef = tex.cells;
        if (cache != null && cache.texWidth == tex.width && cache.texHeight == tex.height && cache.texCellsRef == cellsRef) {
            return cache;
        }
        int PUFFS_PER_CELL = 6;
        float PUFF_MIN_SIZE = 1.8f;
        float PUFF_MAX_SIZE = 5.2f;
        float PUFF_HEIGHT_FACTOR = 0.45f;
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        float PUFF_MAX_VERTICAL = 4.0f * (layerConfiguration.IS_ENABLED ? layerConfiguration.CLOUD_Y_SCALE : 1.0f);
        LayerCache pc = new LayerCache(tex.width, tex.height, cellsRef, 6, currentLayer);
        long[] cells = tex.cells;
        int w = tex.width;
        int h = tex.height;
        for (int tz = 0; tz < h; ++tz) {
            for (int tx = 0; tx < w; ++tx) {
                int idx = tx + tz * w;
                long cell = cells[idx];
                if (cell == 0L) {
                    pc.puffByCell[idx] = null;
                    continue;
                }
                PuffDesc[] arr = new PuffDesc[6];
                long cellSeed = ((long)tx & 0xFFFFL) << 32 | ((long)tz & 0xFFFFL) << 16 | (long)currentLayer & 0xFFFFL;
                for (int p = 0; p < 6; ++p) {
                    float localZ;
                    float localX;
                    long puffSeed = cellSeed + (long)p * -7046029254386353131L;
                    long s0 = PuffMeshBuilder.splitmix64(puffSeed);
                    float rr0 = PuffMeshBuilder.uint64ToFloat01(s0);
                    long s1 = PuffMeshBuilder.splitmix64(s0);
                    float rr1 = PuffMeshBuilder.uint64ToFloat01(s1);
                    long s2 = PuffMeshBuilder.splitmix64(s1);
                    float rr2 = PuffMeshBuilder.uint64ToFloat01(s2);
                    float hr = class_3532.method_16439((float)rr0, (float)1.8f, (float)5.2f);
                    float vr = hr * 0.45f;
                    if (MeshBuilder.PUFF_MODE == MeshBuilder.PuffMode.COMPACT) {
                        int clusterCount = 1 + (int)(PuffMeshBuilder.uint64ToFloat01(PuffMeshBuilder.splitmix64(cellSeed)) * 3.0f);
                        int clusterIndex = p % clusterCount;
                        long clusterSeed = cellSeed + (long)clusterIndex * 3517706253L;
                        long cs0 = PuffMeshBuilder.splitmix64(clusterSeed);
                        long cs1 = PuffMeshBuilder.splitmix64(cs0);
                        float cxOffset = PuffMeshBuilder.uint64ToFloat01(cs0) * 12.0f;
                        float czOffset = PuffMeshBuilder.uint64ToFloat01(cs1) * 12.0f;
                        float angleF = rr1 * (float)Math.PI * 2.0f;
                        int idxTable = (int)((double)angleF / (Math.PI * 2) * 1024.0) & 0x3FF;
                        float cosv = cosTable[idxTable];
                        float sinv = sinTable[idxTable];
                        float dist = rr2 * 3.0f;
                        float jitterX = cosv * dist;
                        float jitterZ = sinv * dist;
                        localX = cxOffset + jitterX;
                        localZ = czOffset + jitterZ;
                    } else {
                        float OVERLAP = hr * 1.25f;
                        float localXRaw = rr1 * (12.0f + OVERLAP * 2.0f) - OVERLAP;
                        float localZRaw = rr2 * (12.0f + OVERLAP * 2.0f) - OVERLAP;
                        localX = localXRaw;
                        localZ = localZRaw;
                    }
                    float baseY = PuffMeshBuilder.uint64ToFloat01(PuffMeshBuilder.splitmix64(s2)) * (PUFF_MAX_VERTICAL - vr);
                    baseY = class_3532.method_15363((float)baseY, (float)0.0f, (float)(PUFF_MAX_VERTICAL - vr));
                    arr[p] = new PuffDesc(localX, localZ, hr, vr, baseY);
                }
                pc.puffByCell[idx] = arr;
            }
        }
        LayerCaches.put(key, pc);
        return pc;
    }

    @Override
    public class_287 Build(class_287 bb, Texture.TextureData tex, CustomCloudRenderer.RelativeCameraPos pos, CustomCloudRenderer.LayerState state, int cx, int cz, float relY, int currentLayer, int skyColor, float offX, float offZ) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        int RANGE = 32;
        int PUFFS_PER_CELL = 6;
        float PUFF_MIN_SIZE = 1.8f;
        float PUFF_MAX_SIZE = 5.2f;
        float PUFF_HEIGHT_FACTOR = 0.45f;
        float Y_JITTER = 0.2f;
        long[] cells = tex.cells;
        int w = tex.width;
        int h = tex.height;
        LayerCache pc = PuffMeshBuilder.ensureCache(tex, currentLayer);
        float cellSize = 12.0f;
        for (int dz = -32; dz <= 32; ++dz) {
            for (int dx = -32; dx <= 32; ++dx) {
                PuffDesc[] puffs;
                int tz;
                int tx = Math.floorMod(cx + dx, w);
                long cell = cells[tx + (tz = Math.floorMod(cz + dz, h)) * w];
                if (cell == 0L) continue;
                float baseX = (float)dx * 12.0f;
                float baseZ = (float)dz * 12.0f;
                int alpha = (int)(cell >> 36 & 0xFFL);
                if (alpha <= 3 || (puffs = pc.puffByCell[tx + tz * w]) == null) continue;
                block5: for (int p = 0; p < 6; ++p) {
                    PuffDesc pd = puffs[p];
                    if (pd == null) continue;
                    float px = baseX + pd.localX;
                    float pz = baseZ + pd.localZ;
                    float hr = pd.hr;
                    float vr = pd.vr;
                    float py = pd.baseY + ((float)p * 0.2f * 0.1f + (float)p * 1.0E-4f);
                    CloudsConfiguration.LayerConfiguration lc = layerConfiguration;
                    float PUFF_MAX_VERTICAL = 4.0f * (lc.IS_ENABLED ? lc.CLOUD_Y_SCALE : 1.0f);
                    py = class_3532.method_15363((float)py, (float)0.0f, (float)(PUFF_MAX_VERTICAL - vr));
                    int topColor = ColorUtils.recolor(MeshBuilder.topColor, py + vr, pos, relY, currentLayer, skyColor);
                    int bottomColor = ColorUtils.recolor(MeshBuilder.innerColor, py, pos, relY, currentLayer, skyColor);
                    int sideColorTop = ColorUtils.recolor(MeshBuilder.sideColor, py + vr, pos, relY, currentLayer, skyColor);
                    int sideColorBottom = ColorUtils.recolor(MeshBuilder.sideColor, py, pos, relY, currentLayer, skyColor);
                    float topR = ARGB.redFloat(topColor);
                    float topG = ARGB.greenFloat(topColor);
                    float topB = ARGB.blueFloat(topColor);
                    float topA = ARGB.alphaFloat(topColor);
                    float bottomR = ARGB.redFloat(bottomColor);
                    float bottomG = ARGB.greenFloat(bottomColor);
                    float bottomB = ARGB.blueFloat(bottomColor);
                    float bottomA = ARGB.alphaFloat(bottomColor);
                    float sideTopR = ARGB.redFloat(sideColorTop);
                    float sideTopG = ARGB.greenFloat(sideColorTop);
                    float sideTopB = ARGB.blueFloat(sideColorTop);
                    float sideTopA = ARGB.alphaFloat(sideColorTop);
                    float sideBottomR = ARGB.redFloat(sideColorBottom);
                    float sideBottomG = ARGB.greenFloat(sideColorBottom);
                    float sideBottomB = ARGB.blueFloat(sideColorBottom);
                    float sideBottomA = ARGB.alphaFloat(sideColorBottom);
                    switch (MeshBuilder.SHAPE) {
                        case CROSS: {
                            PuffMeshBuilder.drawCross(bb, px, py, pz, hr, vr, topR, topG, topB, topA, bottomR, bottomG, bottomB, bottomA);
                            continue block5;
                        }
                        default: {
                            PuffMeshBuilder.drawCube(bb, px, py, pz, hr, vr, topR, topG, topB, topA, bottomR, bottomG, bottomB, bottomA, sideTopR, sideTopG, sideTopB, sideTopA, sideBottomR, sideBottomG, sideBottomB, sideBottomA);
                        }
                    }
                }
            }
        }
        return bb;
    }

    private static void drawCube(class_287 bb, float cx, float cy, float cz, float hr, float vr, float topR, float topG, float topB, float topA, float bottomR, float bottomG, float bottomB, float bottomA, float sideTopR, float sideTopG, float sideTopB, float sideTopA, float sideBottomR, float sideBottomG, float sideBottomB, float sideBottomA) {
        float x0 = cx - hr;
        float x1 = cx + hr;
        float y0 = cy;
        float y1 = cy + vr;
        float z0 = cz - hr;
        float z1 = cz + hr;
        bb.method_22912((double)x0, (double)y1, (double)z1).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z1).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z0).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)x0, (double)y1, (double)z0).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z0).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z0).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z1).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z1).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z1).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z1).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z1).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x0, (double)y1, (double)z1).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z0).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z0).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x0, (double)y1, (double)z0).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z0).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z0).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x0, (double)y0, (double)z1).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x0, (double)y1, (double)z1).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x0, (double)y1, (double)z0).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z1).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x1, (double)y0, (double)z0).method_22915(sideBottomR, sideBottomG, sideBottomB, sideBottomA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z0).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
        bb.method_22912((double)x1, (double)y1, (double)z1).method_22915(sideTopR, sideTopG, sideTopB, sideTopA).method_1344();
    }

    private static void drawCross(class_287 bb, float cx, float cy, float cz, float hr, float vr, float topR, float topG, float topB, float topA, float bottomR, float bottomG, float bottomB, float bottomA) {
        float y0 = cy;
        float y1 = cy + vr;
        bb.method_22912((double)(cx - hr), (double)y0, (double)cz).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)(cx + hr), (double)y0, (double)cz).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)(cx + hr), (double)y1, (double)cz).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)(cx - hr), (double)y1, (double)cz).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)cx, (double)y0, (double)(cz - hr)).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)cx, (double)y0, (double)(cz + hr)).method_22915(bottomR, bottomG, bottomB, bottomA).method_1344();
        bb.method_22912((double)cx, (double)y1, (double)(cz + hr)).method_22915(topR, topG, topB, topA).method_1344();
        bb.method_22912((double)cx, (double)y1, (double)(cz - hr)).method_22915(topR, topG, topB, topA).method_1344();
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            double a = Math.PI * 2 * (double)i / 1024.0;
            PuffMeshBuilder.sinTable[i] = (float)Math.sin(a);
            PuffMeshBuilder.cosTable[i] = (float)Math.cos(a);
        }
        LayerCaches = new ConcurrentHashMap<String, LayerCache>(4);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class LayerCache {
        final int texWidth;
        final int texHeight;
        final Object texCellsRef;
        final int puffCount;
        final PuffDesc[][] puffByCell;
        final int currentLayer;

        LayerCache(int texWidth, int texHeight, Object texCellsRef, int puffCount, int currentLayer) {
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.texCellsRef = texCellsRef;
            this.puffCount = puffCount;
            this.puffByCell = new PuffDesc[texWidth * texHeight][];
            this.currentLayer = currentLayer;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class PuffDesc {
        final float localX;
        final float localZ;
        final float hr;
        final float vr;
        final float baseY;

        PuffDesc(float localX, float localZ, float hr, float vr, float baseY) {
            this.localX = localX;
            this.localZ = localZ;
            this.hr = hr;
            this.vr = vr;
            this.baseY = baseY;
        }
    }
}

