/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.utils;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PerlinNoise {
    private final int[] permutation = new int[512];

    public PerlinNoise(long seed) {
        int i;
        int[] p = new int[256];
        Random rand = new Random(seed);
        for (i = 0; i < 256; ++i) {
            p[i] = i;
        }
        for (i = 255; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            int tmp = p[i];
            p[i] = p[j];
            p[j] = tmp;
        }
        for (i = 0; i < 512; ++i) {
            this.permutation[i] = p[i & 0xFF];
        }
    }

    private static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    public double noise(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = PerlinNoise.fade(x);
        double v = PerlinNoise.fade(y);
        double w = PerlinNoise.fade(z);
        int A = this.permutation[X] + Y;
        int AA = this.permutation[A] + Z;
        int AB = this.permutation[A + 1] + Z;
        int B = this.permutation[X + 1] + Y;
        int BA = this.permutation[B] + Z;
        int BB = this.permutation[B + 1] + Z;
        return PerlinNoise.lerp(w, PerlinNoise.lerp(v, PerlinNoise.lerp(u, PerlinNoise.grad(this.permutation[AA], x, y, z), PerlinNoise.grad(this.permutation[BA], x - 1.0, y, z)), PerlinNoise.lerp(u, PerlinNoise.grad(this.permutation[AB], x, y - 1.0, z), PerlinNoise.grad(this.permutation[BB], x - 1.0, y - 1.0, z))), PerlinNoise.lerp(v, PerlinNoise.lerp(u, PerlinNoise.grad(this.permutation[AA + 1], x, y, z - 1.0), PerlinNoise.grad(this.permutation[BA + 1], x - 1.0, y, z - 1.0)), PerlinNoise.lerp(u, PerlinNoise.grad(this.permutation[AB + 1], x, y - 1.0, z - 1.0), PerlinNoise.grad(this.permutation[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public double noise(double x, double y) {
        return this.noise(x, y, 0.0);
    }
}

