/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.mixin;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.CloudRendererHolder;
import net.not_thefirst.story_mode_clouds.utils.Texture;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class}, priority=16384)
public abstract class LevelRendererMixin
implements CloudRendererHolder {
    private CustomCloudRenderer cloudRenderer;

    @Override
    public CustomCloudRenderer getCloudRenderer() {
        return this.cloudRenderer;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initializeConstructor(class_310 minecraft, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 renderBuffers, CallbackInfo ci) {
        this.cloudRenderer = new CustomCloudRenderer();
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptCloudRender(class_4587 poseStack, Matrix4f modelViewMatrix, float partialTicks, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        ci.cancel();
        if (!CloudsConfiguration.INSTANCE.CLOUDS_RENDERED) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        if (this.cloudRenderer != null && this.cloudRenderer.currentTexture.isEmpty()) {
            Optional<Texture.TextureData> texture = this.cloudRenderer.prepare(client.method_1478(), client.method_16011());
            this.cloudRenderer.apply(texture, client.method_1478(), client.method_16011());
        }
        class_4063 status = client.field_1690.method_1632();
        float cloudHeight = client.field_1687.method_28103().method_28108();
        class_243 vanillaColor = client.field_1687.method_23785(partialTicks);
        int color = ARGB.colorFromFloat(1.0f, (float)vanillaColor.field_1352, (float)vanillaColor.field_1351, (float)vanillaColor.field_1350);
        class_243 cam = new class_243(cameraX, cameraY, cameraZ);
        this.renderCloud(poseStack, color, cloudHeight, status, modelViewMatrix, cam, partialTicks);
    }

    private void renderCloud(class_4587 poseStack, int color, float cloudHeight, class_4063 status, Matrix4f modelViewMatrix, class_243 vec3, float partialTicks) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1769 == null) {
            return;
        }
        if (this.cloudRenderer == null) {
            this.cloudRenderer = new CustomCloudRenderer();
        }
        this.cloudRenderer.render(color, status, cloudHeight, modelViewMatrix, vec3, partialTicks, poseStack);
    }
}

