/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.utils;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ARGB {
    public static int WHITE = -1;
    public static int BLACK = -16777216;

    private ARGB() {
    }

    public static int alpha(int color) {
        return color >>> 24 & 0xFF;
    }

    public static int red(int color) {
        return color >>> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >>> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static float alphaFloat(int color) {
        return (float)ARGB.alpha(color) / 255.0f;
    }

    public static float redFloat(int color) {
        return (float)ARGB.red(color) / 255.0f;
    }

    public static float greenFloat(int color) {
        return (float)ARGB.green(color) / 255.0f;
    }

    public static float blueFloat(int color) {
        return (float)ARGB.blue(color) / 255.0f;
    }

    public static int color(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int colorFromFloat(float a, float r, float g, float b) {
        return ARGB.color((int)(a * 255.0f + 0.5f), (int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f));
    }

    public static int withAlpha(int color, int alpha) {
        return color & 0xFFFFFF | (alpha & 0xFF) << 24;
    }

    public static int withAlphaFloat(int color, float alpha) {
        return ARGB.withAlpha(color, (int)(alpha * 255.0f + 0.5f));
    }

    public static int lerp(int colorA, int colorB, float t) {
        t = ARGB.clamp01(t);
        int a = (int)((float)ARGB.alpha(colorA) + (float)(ARGB.alpha(colorB) - ARGB.alpha(colorA)) * t);
        int r = (int)((float)ARGB.red(colorA) + (float)(ARGB.red(colorB) - ARGB.red(colorA)) * t);
        int g = (int)((float)ARGB.green(colorA) + (float)(ARGB.green(colorB) - ARGB.green(colorA)) * t);
        int b = (int)((float)ARGB.blue(colorA) + (float)(ARGB.blue(colorB) - ARGB.blue(colorA)) * t);
        return ARGB.color(a, r, g, b);
    }

    public static int multiply(int colorA, int colorB) {
        int a = ARGB.alpha(colorA) * ARGB.alpha(colorB) / 255;
        int r = ARGB.red(colorA) * ARGB.red(colorB) / 255;
        int g = ARGB.green(colorA) * ARGB.green(colorB) / 255;
        int b = ARGB.blue(colorA) * ARGB.blue(colorB) / 255;
        return ARGB.color(a, r, g, b);
    }

    public static int multiply(int color, float scalar) {
        scalar = ARGB.clamp01(scalar);
        int a = (int)((float)ARGB.alpha(color) * scalar);
        int r = (int)((float)ARGB.red(color) * scalar);
        int g = (int)((float)ARGB.green(color) * scalar);
        int b = (int)((float)ARGB.blue(color) * scalar);
        return ARGB.color(a, r, g, b);
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }
}

