/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.utils;

import net.minecraft.class_3532;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.utils.ARGB;

public class ColorUtils {
    public static int recolor(int color, int currentLayer, int skyColor) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        if (!layerConfiguration.IS_ENABLED) {
            return ARGB.multiply(color, skyColor);
        }
        boolean shaded = layerConfiguration.APPEARS_SHADED;
        boolean useAlpha = layerConfiguration.USES_CUSTOM_ALPHA;
        boolean useColor = layerConfiguration.USES_CUSTOM_COLOR;
        float baseAlpha = useAlpha ? (float)layerConfiguration.BASE_ALPHA / 255.0f : ARGB.alphaFloat(color);
        int customColor = layerConfiguration.LAYER_COLOR;
        float r = ARGB.redFloat(color);
        float g = ARGB.greenFloat(color);
        float b = ARGB.blueFloat(color);
        if (!shaded && useColor) {
            r = ARGB.redFloat(customColor);
            g = ARGB.greenFloat(customColor);
            b = ARGB.blueFloat(customColor);
        } else if (useColor) {
            r *= ARGB.redFloat(customColor);
            g *= ARGB.greenFloat(customColor);
            b *= ARGB.blueFloat(customColor);
        }
        if (!layerConfiguration.CUSTOM_BRIGHTNESS) {
            float cloudR = ARGB.redFloat(skyColor);
            float cloudG = ARGB.greenFloat(skyColor);
            float cloudB = ARGB.blueFloat(skyColor);
            r *= cloudR;
            g *= cloudG;
            b *= cloudB;
        }
        return ARGB.colorFromFloat(baseAlpha, r, g, b);
    }

    public static int recolor(int color, float vertexY, CustomCloudRenderer.RelativeCameraPos pos, float relY, int currentLayer, int skyColor) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        if (!layerConfiguration.IS_ENABLED) {
            return ARGB.multiply(color, skyColor);
        }
        boolean shaded = layerConfiguration.APPEARS_SHADED;
        boolean useAlpha = layerConfiguration.USES_CUSTOM_ALPHA;
        boolean useColor = layerConfiguration.USES_CUSTOM_COLOR;
        float baseAlpha = useAlpha ? (float)layerConfiguration.BASE_ALPHA / 255.0f : ARGB.alphaFloat(color);
        float fadeAlpha = (float)layerConfiguration.FADE_ALPHA / 255.0f;
        int customColor = layerConfiguration.LAYER_COLOR;
        float r = ARGB.redFloat(color);
        float g = ARGB.greenFloat(color);
        float b = ARGB.blueFloat(color);
        if (!shaded && useColor) {
            r = ARGB.redFloat(customColor);
            g = ARGB.greenFloat(customColor);
            b = ARGB.blueFloat(customColor);
        } else if (useColor) {
            r *= ARGB.redFloat(customColor);
            g *= ARGB.greenFloat(customColor);
            b *= ARGB.blueFloat(customColor);
        } else if (!shaded) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        }
        if (!layerConfiguration.CUSTOM_BRIGHTNESS) {
            float cloudR = ARGB.redFloat(skyColor);
            float cloudG = ARGB.greenFloat(skyColor);
            float cloudB = ARGB.blueFloat(skyColor);
            r *= cloudR;
            g *= cloudG;
            b *= cloudB;
        }
        if (!layerConfiguration.FADE_ENABLED) {
            return ARGB.colorFromFloat(baseAlpha, r, g, b);
        }
        float cloudHeight = 4.0f * layerConfiguration.CLOUD_Y_SCALE;
        float normalizedY = class_3532.method_15363((float)(vertexY / cloudHeight), (float)0.0f, (float)1.0f);
        float transitionRange = layerConfiguration.TRANSITION_RANGE;
        float dir = class_3532.method_15363((float)(relY / transitionRange), (float)-1.0f, (float)1.0f);
        float fadeBelow = class_3532.method_16439((float)normalizedY, (float)1.0f, (float)fadeAlpha);
        float fadeAbove = class_3532.method_16439((float)(1.0f - normalizedY), (float)1.0f, (float)fadeAlpha);
        float mix = (dir + 1.0f) / 2.0f;
        float fade = class_3532.method_16439((float)mix, (float)fadeBelow, (float)fadeAbove);
        float finalAlpha = baseAlpha * (1.0f - fade);
        return ARGB.colorFromFloat(finalAlpha, r, g, b);
    }
}

