/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_437;
import net.not_thefirst.story_mode_clouds.compat.Compat;
import net.not_thefirst.story_mode_clouds.config.ClothConfigClass;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.renderer.RendererHolder;

public class CloudsConfiguration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cloud_configs.json");
    public boolean CLOUDS_RENDERED = true;
    public static CloudsConfiguration INSTANCE = new CloudsConfiguration();
    private LayerHolder LAYERS = new LayerHolder();

    public LayerHolder getHolder() {
        return this.LAYERS;
    }

    public LayerConfiguration getLayer(int idx) {
        if (this.LAYERS == null || idx < 0 || idx >= this.LAYERS.layers.size()) {
            throw new IndexOutOfBoundsException("Layer index out of bounds: " + idx);
        }
        return this.LAYERS.layers.get(idx);
    }

    public int getLayerCount() {
        return this.LAYERS == null ? 0 : this.LAYERS.layers.size();
    }

    public void applyFromCloth(ClothConfigClass config) {
        int needed;
        if (config == null) {
            return;
        }
        this.CLOUDS_RENDERED = config.global.CLOUDS_RENDERED;
        if (this.LAYERS == null) {
            this.LAYERS = new LayerHolder();
        }
        int n = needed = config.layers != null ? config.layers.layers.size() : 0;
        if (this.LAYERS.layers.size() > needed) {
            while (this.LAYERS.layers.size() > needed) {
                this.LAYERS.layers.remove(this.LAYERS.layers.size() - 1);
            }
        } else {
            int start;
            for (int i = start = this.LAYERS.layers.size(); i < needed; ++i) {
                this.LAYERS.layers.add(new LayerConfiguration(i));
            }
        }
        for (int i = 0; i < needed; ++i) {
            LayerConfiguration mainLayer = this.LAYERS.layers.get(i);
            LayerConfiguration clothLayer = config.layers.layers.get(i);
            mainLayer.copy(clothLayer);
        }
    }

    public CloudsConfiguration() {
        this.LAYERS.addLayer(new LayerConfiguration(0));
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            CloudsConfiguration.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (CloudsConfiguration)GSON.fromJson((Reader)reader, CloudsConfiguration.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        if (RendererHolder.get() != null) {
            RendererHolder.get().markForRebuild();
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class_437 createConfigScreen(class_437 parent) {
        if (Compat.hasClothConfig()) {
            return (class_437)AutoConfig.getConfigScreen(ClothConfigClass.class, (class_437)parent).get();
        }
        return null;
    }

    public static class LayerHolder {
        public List<LayerConfiguration> layers = new ArrayList<LayerConfiguration>();

        public LayerHolder() {
        }

        public LayerHolder(int layer) {
            this();
            this.addDefaultLayers(layer, idx -> new LayerConfiguration(idx != null ? idx : -1));
        }

        public void addLayer(LayerConfiguration l) {
            this.layers.add(l);
        }

        public void addDefaultLayers(int count, Function<Integer, LayerConfiguration> factory) {
            for (int i = 0; i < count; ++i) {
                this.layers.add(factory.apply(i));
            }
        }

        public void removeLayer(int index) {
            if (index >= 0 && index < this.layers.size()) {
                this.layers.remove(index);
            }
        }

        public void clear() {
            this.layers.clear();
        }
    }

    public static class LayerConfiguration {
        @ConfigEntry.Gui.Excluded
        private int LAYER_IDX;
        public String NAME = "Minecraft";
        public boolean APPEARS_SHADED = false;
        public boolean USES_CUSTOM_ALPHA = true;
        public boolean CUSTOM_BRIGHTNESS = true;
        public boolean USES_CUSTOM_COLOR = false;
        public boolean FADE_ENABLED = true;
        public boolean FOG_ENABLED = true;
        public boolean IS_ENABLED = true;
        public boolean LAYER_RENDERED = true;
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int FADE_ALPHA = 51;
        public int LAYER_HEIGHT = 128;
        public float CLOUD_Y_SCALE = 1.5f;
        public float BRIGHTNESS = 1.0f;
        @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
        public int BASE_ALPHA = 204;
        public float TRANSITION_RANGE = 10.0f;
        public int LAYER_OFFSET_X = 0;
        public int LAYER_OFFSET_Z = 0;
        @ConfigEntry.ColorPicker
        public int LAYER_COLOR = 0xFFFFFF;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public CustomCloudRenderer.CloudMode MODE = CustomCloudRenderer.CloudMode.NORMAL;

        public LayerConfiguration(int idx) {
            this.LAYER_IDX = idx;
        }

        public LayerConfiguration() {
            this(0);
        }

        public int GetLayerIndex() {
            return this.LAYER_IDX;
        }

        void copy(LayerConfiguration layerData) {
            this.APPEARS_SHADED = layerData.APPEARS_SHADED;
            this.USES_CUSTOM_ALPHA = layerData.USES_CUSTOM_ALPHA;
            this.CUSTOM_BRIGHTNESS = layerData.CUSTOM_BRIGHTNESS;
            this.USES_CUSTOM_COLOR = layerData.USES_CUSTOM_COLOR;
            this.FADE_ENABLED = layerData.FADE_ENABLED;
            this.FOG_ENABLED = layerData.FOG_ENABLED;
            this.LAYER_HEIGHT = layerData.LAYER_HEIGHT;
            this.FADE_ALPHA = layerData.FADE_ALPHA;
            this.CLOUD_Y_SCALE = layerData.CLOUD_Y_SCALE;
            this.BRIGHTNESS = layerData.BRIGHTNESS;
            this.BASE_ALPHA = layerData.BASE_ALPHA;
            this.TRANSITION_RANGE = layerData.TRANSITION_RANGE;
            this.LAYER_COLOR = layerData.LAYER_COLOR;
            this.LAYER_IDX = layerData.GetLayerIndex();
            this.MODE = layerData.MODE;
            this.IS_ENABLED = layerData.IS_ENABLED;
            this.LAYER_OFFSET_X = layerData.LAYER_OFFSET_X;
            this.LAYER_OFFSET_Z = layerData.LAYER_OFFSET_Z;
            this.LAYER_RENDERED = layerData.LAYER_RENDERED;
        }
    }
}

