/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.gui;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.not_thefirst.story_mode_clouds.gui.AbstractScrollArea;
import net.not_thefirst.story_mode_clouds.gui.NumericInputField;

@Environment(value=EnvType.CLIENT)
public class ScrollArea
extends AbstractScrollArea {
    private final List<class_339> children = new ArrayList<class_339>();
    private final List<LabelEntry> labels = new ArrayList<LabelEntry>();
    private final List<Runnable> commits = new ArrayList<Runnable>();
    private int nextRowY = 5;
    private final int rowSpacing = 24;
    private final int paddingX = 10;
    private class_339 focusedChild = null;

    public ScrollArea(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
    }

    private double toLocalY(double globalY) {
        return globalY + this.scrollAmount();
    }

    public void addRow(RowBuilder builder) {
        int rowX = this.method_46426() + 10;
        int rowY = this.method_46427() + this.nextRowY;
        int rowWidth = this.field_22758 - 20;
        builder.build(rowX, rowY, rowWidth);
        this.nextRowY += 24;
    }

    public void addLabel(class_2561 text, int x, int y, int color) {
        this.labels.add(new LabelEntry(text, x, y, color));
    }

    public void addWidget(class_339 widget) {
        this.children.add(widget);
    }

    public void registerCommit(Runnable commit) {
        this.commits.add(commit);
    }

    public void commitAll() {
        this.commits.forEach(Runnable::run);
    }

    public int getRight() {
        return this.method_46426() + this.field_22758;
    }

    public int getBottom() {
        return this.method_46427() + this.field_22759;
    }

    @Override
    public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        ScrollArea.method_44379((int)this.method_46426(), (int)this.method_46427(), (int)this.getRight(), (int)this.getBottom());
        int offsetY = (int)this.scrollAmount();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, (float)(-offsetY), 0.0f);
        for (LabelEntry lbl : this.labels) {
            class_310.method_1551().field_1772.method_30883(poseStack, lbl.text, (float)lbl.x, (float)lbl.y, lbl.color);
        }
        for (class_339 w : this.children) {
            w.method_25394(poseStack, mouseX, mouseY + offsetY, delta);
        }
        poseStack.method_22909();
        ScrollArea.method_44380();
    }

    @Override
    public boolean method_25402(double mx, double my, int btn) {
        double localY = this.toLocalY(my);
        for (class_339 w : this.children) {
            if (!w.method_25402(mx, localY, btn)) continue;
            if (this.focusedChild != null) {
                this.focusedChild.method_25365(false);
            }
            this.focusedChild = w;
            this.focusedChild.method_25365(true);
            return true;
        }
        return super.method_25402(mx, my, btn);
    }

    @Override
    public boolean method_25406(double mx, double my, int btn) {
        double localY = this.toLocalY(my);
        boolean consumed = false;
        for (class_339 w : this.children) {
            if (!w.method_25406(mx, localY, btn)) continue;
            consumed = true;
        }
        if (this.focusedChild != null && !(this.focusedChild instanceof NumericInputField)) {
            this.focusedChild.method_25365(false);
            this.focusedChild = null;
        }
        return consumed || super.method_25406(mx, my, btn);
    }

    @Override
    public boolean method_25403(double mx, double my, int btn, double dx, double dy) {
        double localY = this.toLocalY(my);
        boolean consumed = false;
        for (class_339 w : this.children) {
            if (!w.method_25403(mx, localY, btn, dx, dy)) continue;
            consumed = true;
        }
        return consumed || super.method_25403(mx, my, btn, dx, dy);
    }

    @Override
    public boolean method_25404(int key, int scancode, int mods) {
        if (this.focusedChild != null) {
            boolean consumed = this.focusedChild.method_25404(key, scancode, mods);
            if (key == 257 || key == 335) {
                class_339 class_3392 = this.focusedChild;
                if (class_3392 instanceof NumericInputField) {
                    NumericInputField numeric = (NumericInputField)class_3392;
                    numeric.commit();
                }
                this.focusedChild.method_25365(false);
                this.focusedChild = null;
                return true;
            }
            return consumed;
        }
        return super.method_25404(key, scancode, mods);
    }

    public boolean method_25400(char chr, int mods) {
        if (this.focusedChild != null && this.focusedChild.method_25400(chr, mods)) {
            return true;
        }
        return super.method_25400(chr, mods);
    }

    protected int contentHeight() {
        return this.nextRowY + 5;
    }

    @Override
    protected double scrollRate() {
        return 12.0;
    }

    protected void method_47399(class_6382 narration) {
    }

    @Override
    protected int getInnerHeight() {
        return this.contentHeight();
    }

    @Override
    protected void renderContents(class_4587 poseStack, int i, int j, float f) {
        this.method_48579(poseStack, i, j, f);
    }

    @Override
    protected boolean scrollbarVisible() {
        return false;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface RowBuilder {
        public void build(int var1, int var2, int var3);
    }

    @Environment(value=EnvType.CLIENT)
    private record LabelEntry(class_2561 text, int x, int y, int color) {
    }
}

