/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshBuilderRegistry;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.Texture;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CustomCloudRenderer {
    protected static final class_2960 TEXTURE_LOCATION = new class_2960("minecraft", "textures/environment/clouds.png");
    @Nullable
    public Optional<Texture.TextureData> currentTexture = Optional.empty();
    private int prevSkyColor = 0;
    private final List<LayerState> layers = new ArrayList<LayerState>();

    public CustomCloudRenderer() {
        this.rebuildLayerStates();
    }

    private void rebuildLayerStates() {
        int i;
        this.layers.clear();
        int layerCount = CloudsConfiguration.INSTANCE.getLayerCount();
        for (i = 0; i < layerCount; ++i) {
            LayerState layerState = new LayerState(this);
            layerState.texture = null;
            layerState.needsRebuild = true;
            layerState.prevCellX = Integer.MIN_VALUE;
            layerState.prevCellZ = Integer.MIN_VALUE;
            layerState.prevPos = RelativeCameraPos.INSIDE_CLOUDS;
            layerState.prevStatus = null;
            layerState.lastFadeRebuildMs = System.currentTimeMillis();
            this.layers.add(layerState);
        }
        for (i = 0; i < layerCount; ++i) {
            LayerState layer = this.layers.get(i);
            CloudsConfiguration.LayerConfiguration layerConfig = CloudsConfiguration.INSTANCE.getLayer(i);
            layer.offsetX = layerConfig.LAYER_OFFSET_X;
            layer.offsetZ = layerConfig.LAYER_OFFSET_Z;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<Texture.TextureData> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        try (InputStream inputStream = resourceManager.open(TEXTURE_LOCATION);){
            Optional<Texture.TextureData> optional;
            block17: {
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                try {
                    int w = nativeImage.method_4307();
                    int h = nativeImage.method_4323();
                    long[] cells = new long[w * h];
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            int pixel = nativeImage.method_4315(x, y);
                            if (ARGB.alpha(pixel) < 10) {
                                cells[x + y * w] = 0L;
                                continue;
                            }
                            boolean north = ARGB.alpha(nativeImage.method_4315(x, Math.floorMod(y - 1, h))) < 10;
                            boolean east = ARGB.alpha(nativeImage.method_4315(Math.floorMod(x + 1, w), y)) < 10;
                            boolean south = ARGB.alpha(nativeImage.method_4315(x, Math.floorMod(y + 1, h))) < 10;
                            boolean west = ARGB.alpha(nativeImage.method_4315(Math.floorMod(x - 1, w), y)) < 10;
                            cells[x + y * w] = CustomCloudRenderer.packCellData(pixel, north, east, south, west);
                        }
                    }
                    optional = this.currentTexture = Optional.of(new Texture.TextureData(cells, w, h));
                    if (nativeImage == null) break block17;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return optional;
        }
        catch (IOException e) {
            System.out.println("Failed to load cloud texture" + String.valueOf(e));
            return Optional.empty();
        }
    }

    private static long packCellData(int color, boolean north, boolean east, boolean south, boolean west) {
        return (long)color << 4 | (long)((north ? 1 : 0) << 3) | (long)((east ? 1 : 0) << 2) | (long)((south ? 1 : 0) << 1) | (long)(west ? 1 : 0);
    }

    public void apply(Optional<Texture.TextureData> optional, class_3300 resourceManager, class_3695 profilerFiller) {
        Texture.TextureData baseTexture = optional.orElse(this.prepare(resourceManager, profilerFiller).orElse(null));
        for (LayerState layer : this.layers) {
            layer.texture = this.resolveTextureForLayer(layer, baseTexture);
            layer.needsRebuild = true;
        }
    }

    @Nullable
    private Texture.TextureData resolveTextureForLayer(LayerState layer, @Nullable Texture.TextureData fallback) {
        return fallback;
    }

    private void applyTexture() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        if (!this.currentTexture.isPresent()) {
            this.prepare(client.method_1478(), client.method_16011());
        }
        this.apply(this.currentTexture, client.method_1478(), client.method_16011());
    }

    public void render(int cloudColor, class_4063 status, float cloudHeight, Matrix4f modelView, class_243 cam, float tickDelta, class_4587 poseStack) {
        double dx = cam.field_1352 + (double)(tickDelta * 0.03f);
        double dz = cam.field_1350 + (double)3.96f;
        int activeLayers = CloudsConfiguration.INSTANCE.getLayerCount();
        if (activeLayers < 0) {
            return;
        }
        if (activeLayers != this.layers.size()) {
            this.rebuildLayerStates();
            this.applyTexture();
        }
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < activeLayers; ++i) {
            order.add(i);
        }
        order.sort((a, b) -> {
            float ya = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)a.intValue()).LAYER_HEIGHT - cam.field_1351);
            float yb = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)b.intValue()).LAYER_HEIGHT - cam.field_1351);
            return Float.compare(Math.abs(yb), Math.abs(ya));
        });
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableCull();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.depthMask((boolean)true);
        if (class_310.method_29611()) {
            class_310.method_1551().field_1769.method_29364().method_1235(false);
        }
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            int layer = (Integer)iterator.next();
            LayerState currentLayer = this.layers.get(layer);
            CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(layer);
            if (!layerConfiguration.LAYER_RENDERED) continue;
            currentLayer.offsetX = layerConfiguration.LAYER_OFFSET_X;
            currentLayer.offsetZ = layerConfiguration.LAYER_OFFSET_Z;
            Texture.TextureData tex = currentLayer.texture;
            if (tex == null) continue;
            double wrapX = (float)tex.width * 12.0f;
            double wrapZ = (float)tex.height * 12.0f;
            double dxLayer = dx + (double)currentLayer.offsetX;
            double dzLayer = dz + (double)currentLayer.offsetZ;
            dxLayer -= (double)class_3532.method_15357((double)(dxLayer / wrapX)) * wrapX;
            dzLayer -= (double)class_3532.method_15357((double)(dzLayer / wrapZ)) * wrapZ;
            float layerY = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)layer).LAYER_HEIGHT - cam.field_1351);
            float cloudChunkHeight = 4.0f * (layerConfiguration.IS_ENABLED ? layerConfiguration.CLOUD_Y_SCALE : 1.0f);
            float relYTop = layerY + cloudChunkHeight;
            RelativeCameraPos layerPos = relYTop < 0.0f ? RelativeCameraPos.ABOVE_CLOUDS : (layerY > 0.0f ? RelativeCameraPos.BELOW_CLOUDS : RelativeCameraPos.INSIDE_CLOUDS);
            int cellX = class_3532.method_15357((double)(dxLayer / 12.0));
            int cellZ = class_3532.method_15357((double)(dzLayer / 12.0));
            float offX = (float)(dxLayer - (double)((float)cellX * 12.0f));
            float offZ = (float)(dzLayer - (double)((float)cellZ * 12.0f));
            long now = System.currentTimeMillis();
            float relY = relYTop - cloudChunkHeight / 2.0f;
            if (layerConfiguration.IS_ENABLED && layerConfiguration.FADE_ENABLED && Math.abs(relY) <= layerConfiguration.TRANSITION_RANGE && now - currentLayer.lastFadeRebuildMs > 40L) {
                currentLayer.needsRebuild = true;
                currentLayer.lastFadeRebuildMs = now;
            }
            if (layerConfiguration.IS_ENABLED && layerConfiguration.CUSTOM_BRIGHTNESS && cloudColor != this.prevSkyColor) {
                currentLayer.needsRebuild = true;
                if (layer == 0) {
                    this.prevSkyColor = cloudColor;
                }
            }
            if (currentLayer.needsRebuild || cellX != currentLayer.prevCellX || cellZ != currentLayer.prevCellZ || layerPos != currentLayer.prevPos || status != currentLayer.prevStatus || cloudColor != this.prevSkyColor) {
                currentLayer.needsRebuild = false;
                currentLayer.prevCellX = cellX;
                currentLayer.prevCellZ = cellZ;
                currentLayer.prevPos = layerPos;
                currentLayer.prevStatus = status;
                currentLayer.currentStatus = status;
                this.prevSkyColor = cloudColor;
                if (currentLayer.buffer != null) {
                    currentLayer.buffer.close();
                }
                currentLayer.buffer = new class_291();
                class_287.class_7433 mesh = this.buildMeshForLayer(tex, class_289.method_1348(), cellX, cellZ, status, layerPos, relY, layer, cloudColor, offX, offZ);
                if (mesh != null) {
                    currentLayer.buffer.method_1353();
                    currentLayer.buffer.method_1352(mesh);
                    class_291.method_1354();
                    currentLayer.bufferEmpty = false;
                } else {
                    currentLayer.bufferEmpty = true;
                }
            }
            poseStack.method_22903();
            poseStack.method_46416(-offX, layerY, -offZ);
            if (!currentLayer.bufferEmpty) {
                float CUSTOM_BRIGHTNESS = layerConfiguration.BRIGHTNESS;
                float originalFogEnd = RenderSystem.getShaderFogEnd();
                if (layerConfiguration.CUSTOM_BRIGHTNESS && layerConfiguration.IS_ENABLED) {
                    RenderSystem.setShaderColor((float)CUSTOM_BRIGHTNESS, (float)CUSTOM_BRIGHTNESS, (float)CUSTOM_BRIGHTNESS, (float)1.0f);
                }
                if (!layerConfiguration.FOG_ENABLED) {
                    RenderSystem.setShaderFogEnd((float)262144.0f);
                }
                currentLayer.buffer.method_1353();
                RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.drawBuffer(poseStack.method_23760().method_23761(), modelView, offX, layerY, offZ, currentLayer.buffer);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.drawBuffer(poseStack.method_23760().method_23761(), modelView, offX, layerY, offZ, currentLayer.buffer);
                class_291.method_1354();
                RenderSystem.setShaderFogEnd((float)originalFogEnd);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            poseStack.method_22909();
        }
        if (class_310.method_29611()) {
            class_310.method_1551().method_1522().method_1235(false);
        }
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    private void drawBuffer(Matrix4f proj, Matrix4f mv, float ox, float oy, float oz, class_291 buf) {
        class_5944 shader = class_757.method_34540();
        buf.method_34427(proj, mv, shader);
    }

    @Nullable
    private class_287.class_7433 buildMeshForLayer(Texture.TextureData tex, class_289 tess, int cx, int cz, class_4063 status, RelativeCameraPos pos, float relY, int currentLayer, int skyColor, float offX, float offZ) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        LayerState state = this.layers.get(currentLayer);
        class_287 bb = tess.method_1349();
        bb.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        MeshTypeBuilder builder = MeshBuilderRegistry.getBuilder(layerConfiguration.MODE.name());
        builder.Build(bb, tex, pos, state, cx, cz, relY, currentLayer, skyColor, offX, offZ);
        return bb.method_1326();
    }

    public void markForRebuild(int layer) {
        if (layer >= 0 && layer < this.layers.size()) {
            this.layers.get((int)layer).needsRebuild = true;
        }
    }

    public void markForRebuild() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get((int)i).needsRebuild = true;
        }
    }

    public void close() {
        for (LayerState layer : this.layers) {
            if (layer.buffer == null) continue;
            layer.buffer.close();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class LayerState {
        public int index;
        public float offsetX;
        public float offsetZ;
        public Texture.TextureData texture;
        public class_291 buffer;
        public int indexCount;
        public boolean needsRebuild;
        public int prevCellX;
        public int prevCellZ;
        public RelativeCameraPos prevPos;
        public class_4063 prevStatus;
        public class_4063 currentStatus;
        public long lastFadeRebuildMs;
        public float prevFadeMix;
        public boolean bufferEmpty;

        public LayerState(CustomCloudRenderer this$0, int index) {
            this.index = index;
        }

        public LayerState(CustomCloudRenderer this$0) {
            this(this$0, -1);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RelativeCameraPos {
        ABOVE_CLOUDS,
        INSIDE_CLOUDS,
        BELOW_CLOUDS;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum CloudMode {
        NORMAL,
        POPULATED;

    }
}

