/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer;

import java.util.Optional;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.phys.Vec3;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.utils.Texture;

public class RendererHolder {
    private static CustomCloudRenderer renderer = null;

    public static CustomCloudRenderer get() {
        return renderer;
    }

    public static void initialize() {
    }

    public static void renderCloud(int cloudColor, CloudStatus status, float cloudHeight, Vec3 vec3, float partialTicks) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null || client.levelRenderer == null) {
            return;
        }
        if (renderer == null) {
            renderer = new CustomCloudRenderer();
        }
        if (RendererHolder.renderer.currentTexture.isEmpty()) {
            Optional<Texture.TextureData> texture = renderer.prepare(client.getResourceManager(), Profiler.get());
            renderer.apply(texture, client.getResourceManager(), Profiler.get());
        }
        if (!CloudsConfiguration.INSTANCE.CLOUDS_RENDERED) {
            return;
        }
        renderer.render(cloudColor, status, cloudHeight, vec3, partialTicks);
    }
}

