/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.world.InteractionResult;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.not_thefirst.story_mode_clouds.Initializer;
import net.not_thefirst.story_mode_clouds.compat.Compat;
import net.not_thefirst.story_mode_clouds.compat.ForgeModChecker;
import net.not_thefirst.story_mode_clouds.config.ClothConfigClass;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;

@Mod(value="cloud_tweaks")
public class StoryModeClouds {
    public StoryModeClouds() {
        ModLoadingContext ctx = ModLoadingContext.get();
        StoryModeClouds.initialize();
        ctx.getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, parent) -> CloudsConfiguration.createConfigScreen(parent)));
    }

    public static void initialize() {
        Compat.init(new ForgeModChecker());
        Initializer.initialize();
        if (Compat.hasClothConfig()) {
            ConfigHolder holder = AutoConfig.register(ClothConfigClass.class, GsonConfigSerializer::new);
            holder.registerSaveListener((manager, data) -> {
                CloudsConfiguration.INSTANCE.applyFromCloth((ClothConfigClass)data);
                CloudsConfiguration.save();
                return InteractionResult.SUCCESS;
            });
            holder.registerLoadListener((manager, data) -> {
                data.applyFromMain(CloudsConfiguration.INSTANCE);
                return InteractionResult.SUCCESS;
            });
        }
    }
}

