/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer;

import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshBuilderRegistry;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.Texture;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CustomCloudRenderer {
    protected static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/clouds.png");
    @Nullable
    public Optional<Texture.TextureData> currentTexture = Optional.empty();
    private int prevSkyColor = 0;
    private final List<LayerState> layers = new ArrayList<LayerState>();

    public CustomCloudRenderer() {
        this.rebuildLayerStates();
    }

    private void rebuildLayerStates() {
        int i;
        this.layers.clear();
        int layerCount = CloudsConfiguration.INSTANCE.getLayerCount();
        for (i = 0; i < layerCount; ++i) {
            LayerState layerState = new LayerState(this);
            layerState.texture = null;
            layerState.needsRebuild = true;
            layerState.prevCellX = Integer.MIN_VALUE;
            layerState.prevCellZ = Integer.MIN_VALUE;
            layerState.prevPos = RelativeCameraPos.INSIDE_CLOUDS;
            layerState.prevStatus = null;
            layerState.lastFadeRebuildMs = System.currentTimeMillis();
            this.layers.add(layerState);
        }
        for (i = 0; i < layerCount; ++i) {
            LayerState layer = this.layers.get(i);
            CloudsConfiguration.LayerConfiguration layerConfig = CloudsConfiguration.INSTANCE.getLayer(i);
            layer.offsetX = layerConfig.LAYER_OFFSET_X;
            layer.offsetZ = layerConfig.LAYER_OFFSET_Z;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<Texture.TextureData> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        try (InputStream inputStream = resourceManager.open(TEXTURE_LOCATION);){
            Optional<Texture.TextureData> optional;
            block17: {
                NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                try {
                    int w = nativeImage.getWidth();
                    int h = nativeImage.getHeight();
                    long[] cells = new long[w * h];
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            int pixel = nativeImage.getPixel(x, y);
                            if (ARGB.alpha(pixel) < 10) {
                                cells[x + y * w] = 0L;
                                continue;
                            }
                            boolean north = ARGB.alpha(nativeImage.getPixel(x, Math.floorMod(y - 1, h))) < 10;
                            boolean east = ARGB.alpha(nativeImage.getPixel(Math.floorMod(x + 1, w), y)) < 10;
                            boolean south = ARGB.alpha(nativeImage.getPixel(x, Math.floorMod(y + 1, h))) < 10;
                            boolean west = ARGB.alpha(nativeImage.getPixel(Math.floorMod(x - 1, w), y)) < 10;
                            cells[x + y * w] = CustomCloudRenderer.packCellData(pixel, north, east, south, west);
                        }
                    }
                    optional = this.currentTexture = Optional.of(new Texture.TextureData(cells, w, h));
                    if (nativeImage == null) break block17;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return optional;
        }
        catch (IOException e) {
            System.out.println("Failed to load cloud texture" + String.valueOf(e));
            return Optional.empty();
        }
    }

    private static long packCellData(int color, boolean north, boolean east, boolean south, boolean west) {
        return (long)color << 4 | (long)((north ? 1 : 0) << 3) | (long)((east ? 1 : 0) << 2) | (long)((south ? 1 : 0) << 1) | (long)(west ? 1 : 0);
    }

    public void apply(Optional<Texture.TextureData> optional, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Texture.TextureData baseTexture = optional.orElse(this.prepare(resourceManager, profilerFiller).orElse(null));
        for (LayerState layer : this.layers) {
            layer.texture = this.resolveTextureForLayer(layer, baseTexture);
            layer.needsRebuild = true;
        }
    }

    @Nullable
    private Texture.TextureData resolveTextureForLayer(LayerState layer, @Nullable Texture.TextureData fallback) {
        return fallback;
    }

    private void applyTexture() {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (!this.currentTexture.isPresent()) {
            this.prepare(client.getResourceManager(), Profiler.get());
        }
        this.apply(this.currentTexture, client.getResourceManager(), Profiler.get());
    }

    public void render(int cloudColor, CloudStatus status, float cloudHeight, Matrix4f proj, Matrix4f modelView, Vec3 cam, float tickDelta) {
        double dx = cam.x + (double)(tickDelta * 0.03f);
        double dz = cam.z + (double)3.96f;
        int activeLayers = CloudsConfiguration.INSTANCE.getLayerCount();
        if (activeLayers < 0) {
            return;
        }
        if (activeLayers != this.layers.size()) {
            this.rebuildLayerStates();
            this.applyTexture();
        }
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < activeLayers; ++i) {
            order.add(i);
        }
        order.sort((a, b) -> {
            float ya = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)a.intValue()).LAYER_HEIGHT - cam.y);
            float yb = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)b.intValue()).LAYER_HEIGHT - cam.y);
            return Float.compare(Math.abs(yb), Math.abs(ya));
        });
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            int layer = (Integer)iterator.next();
            LayerState currentLayer = this.layers.get(layer);
            CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(layer);
            if (!layerConfiguration.LAYER_RENDERED) continue;
            currentLayer.offsetX = layerConfiguration.LAYER_OFFSET_X;
            currentLayer.offsetZ = layerConfiguration.LAYER_OFFSET_Z;
            Texture.TextureData tex = currentLayer.texture;
            if (tex == null) continue;
            double wrapX = (float)tex.width * 12.0f;
            double wrapZ = (float)tex.height * 12.0f;
            double dxLayer = dx + (double)currentLayer.offsetX;
            double dzLayer = dz + (double)currentLayer.offsetZ;
            dxLayer -= (double)Mth.floor((double)(dxLayer / wrapX)) * wrapX;
            dzLayer -= (double)Mth.floor((double)(dzLayer / wrapZ)) * wrapZ;
            float layerY = (float)((double)CloudsConfiguration.INSTANCE.getLayer((int)layer).LAYER_HEIGHT - cam.y);
            float cloudChunkHeight = 4.0f * (layerConfiguration.IS_ENABLED ? layerConfiguration.CLOUD_Y_SCALE : 1.0f);
            float relYTop = layerY + cloudChunkHeight;
            RelativeCameraPos layerPos = relYTop < 0.0f ? RelativeCameraPos.ABOVE_CLOUDS : (layerY > 0.0f ? RelativeCameraPos.BELOW_CLOUDS : RelativeCameraPos.INSIDE_CLOUDS);
            int cellX = Mth.floor((double)(dxLayer / 12.0));
            int cellZ = Mth.floor((double)(dzLayer / 12.0));
            float offX = (float)(dxLayer - (double)((float)cellX * 12.0f));
            float offZ = (float)(dzLayer - (double)((float)cellZ * 12.0f));
            long now = System.currentTimeMillis();
            float relY = relYTop - cloudChunkHeight / 2.0f;
            if (layerConfiguration.IS_ENABLED && layerConfiguration.FADE_ENABLED && Math.abs(relY) <= layerConfiguration.TRANSITION_RANGE && now - currentLayer.lastFadeRebuildMs > 40L) {
                currentLayer.needsRebuild = true;
                currentLayer.lastFadeRebuildMs = now;
            }
            if (layerConfiguration.IS_ENABLED && layerConfiguration.CUSTOM_BRIGHTNESS && cloudColor != this.prevSkyColor) {
                currentLayer.needsRebuild = true;
                if (layer == 0) {
                    this.prevSkyColor = cloudColor;
                }
            }
            if (currentLayer.needsRebuild || cellX != currentLayer.prevCellX || cellZ != currentLayer.prevCellZ || layerPos != currentLayer.prevPos || status != currentLayer.prevStatus || cloudColor != this.prevSkyColor && !layerConfiguration.CUSTOM_BRIGHTNESS) {
                currentLayer.needsRebuild = false;
                currentLayer.prevCellX = cellX;
                currentLayer.prevCellZ = cellZ;
                currentLayer.prevPos = layerPos;
                currentLayer.prevStatus = status;
                currentLayer.currentStatus = status;
                this.prevSkyColor = cloudColor;
                if (currentLayer.buffer != null) {
                    currentLayer.buffer.close();
                }
                currentLayer.buffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
                MeshData mesh = this.buildMeshForLayer(tex, Tesselator.getInstance(), cellX, cellZ, status, layerPos, relY, layer, cloudColor, offX, offZ);
                if (mesh != null) {
                    currentLayer.buffer.bind();
                    currentLayer.buffer.upload(mesh);
                    VertexBuffer.unbind();
                    currentLayer.bufferEmpty = false;
                } else {
                    currentLayer.bufferEmpty = true;
                }
            }
            if (currentLayer.bufferEmpty) continue;
            FogParameters originalFog = RenderSystem.getShaderFog();
            if (!layerConfiguration.FOG_ENABLED) {
                RenderSystem.setShaderFog((FogParameters)new FogParameters(Float.MAX_VALUE, 0.0f, FogShape.SPHERE, 0.0f, 0.0f, 0.0f, 0.0f));
            }
            currentLayer.buffer.bind();
            if (status == CloudStatus.FANCY) {
                this.drawWithRenderType(RenderType.cloudsDepthOnly(), proj, modelView, offX, layerY, offZ, currentLayer.buffer);
            }
            this.drawWithRenderType(RenderType.clouds(), proj, modelView, offX, layerY, offZ, currentLayer.buffer);
            VertexBuffer.unbind();
            RenderSystem.setShaderFog((FogParameters)originalFog);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawWithRenderType(RenderType rt, Matrix4f proj, Matrix4f mv, float ox, float oy, float oz, VertexBuffer buf) {
        rt.setupRenderState();
        CompiledShaderProgram shader = RenderSystem.getShader();
        if (shader != null && shader.MODEL_OFFSET != null) {
            shader.MODEL_OFFSET.set(-ox, oy, -oz);
        }
        buf.drawWithShader(proj, mv, shader);
        rt.clearRenderState();
    }

    @Nullable
    private MeshData buildMeshForLayer(Texture.TextureData tex, Tesselator tess, int cx, int cz, CloudStatus status, RelativeCameraPos pos, float relY, int currentLayer, int skyColor, float offX, float offZ) {
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        LayerState state = this.layers.get(currentLayer);
        BufferBuilder bb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        MeshTypeBuilder builder = MeshBuilderRegistry.getBuilder(layerConfiguration.MODE.name());
        builder.Build(bb, tex, pos, state, cx, cz, relY, currentLayer, skyColor, offX, offZ);
        return bb.buildOrThrow();
    }

    public void markForRebuild(int layer) {
        if (layer >= 0 && layer < this.layers.size()) {
            this.layers.get((int)layer).needsRebuild = true;
        }
    }

    public void markForRebuild() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get((int)i).needsRebuild = true;
        }
    }

    public void close() {
        for (LayerState layer : this.layers) {
            if (layer.buffer == null) continue;
            layer.buffer.close();
        }
    }

    public class LayerState {
        public int index;
        public float offsetX;
        public float offsetZ;
        public Texture.TextureData texture;
        public VertexBuffer buffer;
        public int indexCount;
        public boolean needsRebuild;
        public int prevCellX;
        public int prevCellZ;
        public RelativeCameraPos prevPos;
        public CloudStatus prevStatus;
        public CloudStatus currentStatus;
        public long lastFadeRebuildMs;
        public float prevFadeMix;
        public boolean bufferEmpty;

        public LayerState(CustomCloudRenderer this$0, int index) {
            this.index = index;
        }

        public LayerState(CustomCloudRenderer this$0) {
            this(this$0, -1);
        }
    }

    public static enum RelativeCameraPos {
        ABOVE_CLOUDS,
        INSIDE_CLOUDS,
        BELOW_CLOUDS;

    }

    public static enum CloudMode {
        NORMAL,
        POPULATED;

    }
}

