/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.api.keybindings;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.not_thefirst.story_mode_clouds.mixin.KeyMappingAccessor;

public final class KeyMappingHelper {
    private static final List<KeyMapping> KEY_MAPPINGS = new ReferenceArrayList();

    private static Map<String, Integer> getCategoryMap() {
        return KeyMappingAccessor.GetCategoryMap();
    }

    public static boolean addCategory(String categoryTranslationKey) {
        return KeyMappingHelper.getCategoryMap().computeIfAbsent(categoryTranslationKey, key -> KeyMappingHelper.getCategoryMap().values().stream().max(Integer::compareTo).orElse(0) + 1) != null;
    }

    public static KeyMapping registerKeyBinding(KeyMapping binding) {
        if (Minecraft.getInstance().options != null) {
            throw new IllegalStateException("Key mappings cannot be registered in run-time!");
        }
        if (KEY_MAPPINGS.stream().anyMatch(k -> k == binding || k.getTranslatedKeyMessage().equals((Object)binding.getTranslatedKeyMessage()))) {
            throw new IllegalArgumentException("Duplicate key binding: " + String.valueOf(binding.getTranslatedKeyMessage()));
        }
        KeyMappingHelper.addCategory(binding.getCategory());
        KEY_MAPPINGS.add(binding);
        return binding;
    }

    public static KeyMapping[] put(KeyMapping[] keys) {
        return (KeyMapping[])Stream.concat(Arrays.stream(keys).filter(k -> !KEY_MAPPINGS.contains(k)), KEY_MAPPINGS.stream()).toArray(KeyMapping[]::new);
    }
}

