/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.CloudRendererHolder;
import net.not_thefirst.story_mode_clouds.utils.Texture;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=16384)
public abstract class LevelRendererMixin
implements CloudRendererHolder {
    private CustomCloudRenderer cloudRenderer;

    @Override
    public CustomCloudRenderer getCloudRenderer() {
        return this.cloudRenderer;
    }

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at={@At(value="TAIL")})
    private void initializeConstructor(Minecraft minecraft, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers renderBuffers, CallbackInfo ci) {
        this.cloudRenderer = new CustomCloudRenderer();
        System.out.println("[cloud_tweaks] Successfully initialized cloud renderer.");
    }

    @Inject(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptCloudRender(PoseStack poseStack, Matrix4f modelViewMatrix, float partialTicks, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        ci.cancel();
        if (!CloudsConfiguration.INSTANCE.CLOUDS_RENDERED) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (this.cloudRenderer != null && this.cloudRenderer.currentTexture.isEmpty()) {
            Optional<Texture.TextureData> texture = this.cloudRenderer.prepare(client.getResourceManager(), client.getProfiler());
            this.cloudRenderer.apply(texture, client.getResourceManager(), client.getProfiler());
        }
        CloudStatus status = client.options.getCloudsType();
        float cloudHeight = client.level.effects().getCloudHeight();
        Vec3 vanillaColor = client.level.getCloudColor(partialTicks);
        int color = ARGB.colorFromFloat(1.0f, (float)vanillaColor.x, (float)vanillaColor.y, (float)vanillaColor.z);
        Vec3 cam = new Vec3(cameraX, cameraY, cameraZ);
        this.renderCloud(poseStack, color, cloudHeight, status, modelViewMatrix, cam, partialTicks);
    }

    private void renderCloud(PoseStack poseStack, int color, float cloudHeight, CloudStatus status, Matrix4f modelViewMatrix, Vec3 vec3, float partialTicks) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null || client.levelRenderer == null) {
            return;
        }
        if (this.cloudRenderer == null) {
            this.cloudRenderer = new CustomCloudRenderer();
        }
        this.cloudRenderer.render(color, status, cloudHeight, modelViewMatrix, vec3, partialTicks, poseStack);
    }
}

