/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer.mesh_builders;

import com.mojang.blaze3d.vertex.BufferBuilder;
import net.minecraft.client.CloudStatus;
import net.not_thefirst.story_mode_clouds.config.CloudsConfiguration;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.renderer.MeshBuilder;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.utils.ARGB;
import net.not_thefirst.story_mode_clouds.utils.ColorUtils;
import net.not_thefirst.story_mode_clouds.utils.Texture;

public class ClassicMeshBuilder
implements MeshTypeBuilder {
    @Override
    public BufferBuilder Build(BufferBuilder bb, Texture.TextureData tex, CustomCloudRenderer.RelativeCameraPos pos, CustomCloudRenderer.LayerState state, int cx, int cz, float relY, int currentLayer, int skyColor, float chunkOffX, float chunkOffZ) {
        int range = 32;
        long[] cells = tex.cells;
        int w = tex.width;
        int h = tex.height;
        int dxStart = -range;
        int dxEnd = range;
        int dxStep = 1;
        int dzStart = -range;
        int dzEnd = range;
        int dzStep = 1;
        for (int dz = dzStart; dz != dzEnd; dz += dzStep) {
            for (int dx = dxStart; dx != dxEnd; dx += dxStep) {
                int z;
                int x = Math.floorMod(cx + dx, w);
                long cell = cells[x + (z = Math.floorMod(cz + dz, h)) * w];
                if (cell == 0L) continue;
                if (state.currentStatus == CloudStatus.FANCY) {
                    ClassicMeshBuilder.buildExtrudedCell(pos, bb, dx, dz, cell, relY, currentLayer, skyColor);
                    continue;
                }
                ClassicMeshBuilder.buildFlatCell(bb, dx, dz, currentLayer, relY, skyColor);
            }
        }
        return bb;
    }

    private static void buildFlatCell(BufferBuilder bb, int cx, int cz, int currentLayer, float y, int skyColor) {
        float x0 = (float)cx * 12.0f;
        float x1 = x0 + 12.0f;
        float z0 = (float)cz * 12.0f;
        float z1 = z0 + 12.0f;
        int adjustedColor = ColorUtils.recolor(MeshBuilder.topColor, currentLayer, skyColor);
        float colorR = ARGB.redFloat(adjustedColor);
        float colorG = ARGB.greenFloat(adjustedColor);
        float colorB = ARGB.blueFloat(adjustedColor);
        float colorA = ARGB.alphaFloat(adjustedColor);
        bb.vertex((double)x0, 0.0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x1, 0.0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x1, 0.0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x0, 0.0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x0, 0.0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x1, 0.0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x1, 0.0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
        bb.vertex((double)x0, 0.0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
    }

    private static void buildExtrudedCell(CustomCloudRenderer.RelativeCameraPos pos, BufferBuilder bb, int cx, int cz, long cell, float relY, int currentLayer, int skyColor) {
        int colorA;
        int colorB;
        int colorG;
        int colorR;
        int color;
        float x0 = (float)cx * 12.0f;
        float x1 = x0 + 12.0f;
        float y0 = 0.0f;
        float y1 = 4.0f;
        float z0 = (float)cz * 12.0f;
        float z1 = z0 + 12.0f;
        CloudsConfiguration.LayerConfiguration layerConfiguration = CloudsConfiguration.INSTANCE.getLayer(currentLayer);
        float scaledY1 = y1 * (layerConfiguration.IS_ENABLED ? layerConfiguration.CLOUD_Y_SCALE : 1.0f);
        if (pos != CustomCloudRenderer.RelativeCameraPos.BELOW_CLOUDS) {
            color = ColorUtils.recolor(MeshBuilder.topColor, scaledY1, pos, relY, currentLayer, skyColor);
            colorR = ARGB.red(color);
            colorG = ARGB.green(color);
            colorB = ARGB.blue(color);
            colorA = ARGB.alpha(color);
            bb.vertex((double)x0, (double)scaledY1, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x0, (double)scaledY1, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
        }
        if (pos != CustomCloudRenderer.RelativeCameraPos.ABOVE_CLOUDS) {
            color = ColorUtils.recolor(MeshBuilder.innerColor, y0, pos, relY, currentLayer, skyColor);
            colorR = ARGB.red(color);
            colorG = ARGB.green(color);
            colorB = ARGB.blue(color);
            colorA = ARGB.alpha(color);
            bb.vertex((double)x0, (double)y0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x1, (double)y0, (double)z0).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x1, (double)y0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
            bb.vertex((double)x0, (double)y0, (double)z1).color(colorR, colorG, colorB, colorA).endVertex();
        }
        int colorA2 = ColorUtils.recolor(MeshBuilder.sideColor, scaledY1, pos, relY, currentLayer, skyColor);
        int colorB2 = ColorUtils.recolor(MeshBuilder.sideColor, y0, pos, relY, currentLayer, skyColor);
        float colorAR = ARGB.redFloat(colorA2);
        float colorAG = ARGB.greenFloat(colorA2);
        float colorAB = ARGB.blueFloat(colorA2);
        float colorAA = ARGB.alphaFloat(colorA2);
        float colorBR = ARGB.redFloat(colorB2);
        float colorBG = ARGB.greenFloat(colorB2);
        float colorBB = ARGB.blueFloat(colorB2);
        float colorBA = ARGB.alphaFloat(colorB2);
        if (Texture.isSouthEmpty(cell)) {
            bb.vertex((double)x0, (double)y0, (double)z1).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x1, (double)y0, (double)z1).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z1).color(colorAR, colorAG, colorAB, colorAA).endVertex();
            bb.vertex((double)x0, (double)scaledY1, (double)z1).color(colorAR, colorAG, colorAB, colorAA).endVertex();
        }
        if (Texture.isWestEmpty(cell)) {
            bb.vertex((double)x0, (double)y0, (double)z0).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x0, (double)y0, (double)z1).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x0, (double)scaledY1, (double)z1).color(colorAR, colorAG, colorAB, colorAA).endVertex();
            bb.vertex((double)x0, (double)scaledY1, (double)z0).color(colorAR, colorAG, colorAB, colorAA).endVertex();
        }
        if (Texture.isNorthEmpty(cell)) {
            bb.vertex((double)x1, (double)y0, (double)z0).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x0, (double)y0, (double)z0).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x0, (double)scaledY1, (double)z0).color(colorAR, colorAG, colorAB, colorAA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z0).color(colorAR, colorAG, colorAB, colorAA).endVertex();
        }
        if (Texture.isEastEmpty(cell)) {
            bb.vertex((double)x1, (double)y0, (double)z1).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x1, (double)y0, (double)z0).color(colorBR, colorBG, colorBB, colorBA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z0).color(colorAR, colorAG, colorAB, colorAA).endVertex();
            bb.vertex((double)x1, (double)scaledY1, (double)z1).color(colorAR, colorAG, colorAB, colorAA).endVertex();
        }
    }
}

