/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.not_thefirst.story_mode_clouds.gui.ColorPreviewBox;
import net.not_thefirst.story_mode_clouds.gui.NumericInputField;
import net.not_thefirst.story_mode_clouds.gui.ScrollArea;
import net.not_thefirst.story_mode_clouds.gui.SimpleSliderButton;

@Environment(value=EnvType.CLIENT)
public class SimpleConfigScreen
extends class_437 {
    private final class_437 parent;
    private final List<Runnable> onCloseActions = new ArrayList<Runnable>();
    private ScrollArea area;

    public SimpleConfigScreen(class_437 parent, String title) {
        super((class_2561)class_2561.method_43471((String)title));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.area = new ScrollArea(40, 40, this.field_22789 - 80, this.field_22790 - 80);
        this.method_37063((class_364)this.area);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"cloud_tweaks.done"), btn -> {
            this.area.commitAll();
            this.onCloseActions.forEach(Runnable::run);
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
    }

    public void addToggle(String label, boolean initial, Consumer<Boolean> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int buttonWidth = 100;
            int labelWidth = rowWidth - buttonWidth - 6;
            this.area.addLabel((class_2561)class_2561.method_43471((String)label), rowX, rowY + 6, 0xFFFFFF);
            class_5676 button = class_5676.method_32613((boolean)initial).method_32617(rowX + labelWidth + 6, rowY, buttonWidth, 20, (class_2561)class_2561.method_43473(), (btn, value) -> onChange.accept((Boolean)value));
            this.area.addWidget((class_339)button);
        });
    }

    public void addSliderWithBox(String label, double initial, double min, double max, double step, Consumer<Double> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int boxWidth = 55;
            int gap = 6;
            int labelWidth = this.field_22793.method_1727(label) + 4;
            int sliderWidth = rowWidth - labelWidth - boxWidth - 2 * gap;
            this.area.addLabel((class_2561)class_2561.method_43471((String)label), rowX, rowY + 6, 0xFFFFFF);
            SimpleSliderButton slider = new SimpleSliderButton(rowX + labelWidth + gap, rowY, sliderWidth, 20, "", initial, min, max, step, onChange);
            NumericInputField box = new NumericInputField(rowX + rowWidth - boxWidth, rowY, boxWidth, 20, initial, min, max, step, val -> onChange.accept((Double)val));
            slider.onChange = slider.onChange.andThen(val -> box.method_1852(String.format("%.2f", val)));
            box.onChange = box.onChange.andThen(val -> slider.setRealValue((double)val));
            this.area.addWidget((class_339)slider);
            this.area.addWidget((class_339)box);
            this.area.registerCommit(box::commit);
        });
    }

    public void addSlider(String label, double initial, double min, double max, double step, Consumer<Double> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int labelWidth = this.field_22793.method_1727(label) + 4;
            int sliderWidth = rowWidth - labelWidth - 6;
            this.area.addLabel((class_2561)class_2561.method_43471((String)label), rowX, rowY + 6, 0xFFFFFF);
            this.area.addWidget((class_339)new SimpleSliderButton(rowX + labelWidth + 6, rowY, sliderWidth, 20, "", initial, min, max, step, onChange));
        });
    }

    public void onCloseSave(Runnable saveAction) {
        this.onCloseActions.add(saveAction);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_52752(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void addCategory(String text, HorizontalAlignment alignment) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            int yOffset = 6;
            this.area.addLabel((class_2561)class_2561.method_43471((String)text), switch (alignment.ordinal()) {
                case 0 -> rowX;
                case 1 -> rowX + rowWidth / 2 - class_310.method_1551().field_1772.method_1727(text) / 2;
                case 2 -> rowX + rowWidth - class_310.method_1551().field_1772.method_1727(text);
                default -> rowX;
            }, rowY + yOffset, 0xFFFFFF);
        });
    }

    public void addColorPicker(String label, int initialColor, Consumer<Integer> onChange) {
        this.area.addRow((rowX, rowY, rowWidth) -> {
            SimpleSliderButton bSlider;
            SimpleSliderButton gSlider;
            SimpleSliderButton rSlider;
            int gap = 6;
            int previewSize = 20;
            int sliderWidth = (rowWidth - previewSize - 3 * gap) / 3;
            int r = initialColor >> 16 & 0xFF;
            int g = initialColor >> 8 & 0xFF;
            int b = initialColor & 0xFF;
            ColorPreviewBox preview = new ColorPreviewBox(rowX, rowY, previewSize, previewSize, initialColor);
            this.area.addWidget(preview);
            SimpleSliderButton[] rSliderHolder = new SimpleSliderButton[1];
            SimpleSliderButton[] gSliderHolder = new SimpleSliderButton[1];
            SimpleSliderButton[] bSliderHolder = new SimpleSliderButton[1];
            Consumer<Double> updateColor = val -> {
                int newColor = (int)rSliderHolder[0].getRealValue() << 16 | (int)gSliderHolder[0].getRealValue() << 8 | (int)bSliderHolder[0].getRealValue();
                preview.setColor(newColor);
                onChange.accept(newColor);
            };
            rSliderHolder[0] = rSlider = new SimpleSliderButton(rowX + previewSize + gap, rowY, sliderWidth, 20, "R", r, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)rSlider);
            gSliderHolder[0] = gSlider = new SimpleSliderButton(rowX + previewSize + 2 * gap + sliderWidth, rowY, sliderWidth, 20, "G", g, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)gSlider);
            bSliderHolder[0] = bSlider = new SimpleSliderButton(rowX + previewSize + 3 * gap + 2 * sliderWidth, rowY, sliderWidth, 20, "B", b, 0.0, 255.0, 1.0, updateColor);
            this.area.addWidget((class_339)bSlider);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

