/*
 * Decompiled with CFR 0.152.
 */
package net.not_thefirst.story_mode_clouds.renderer.mesh_builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.not_thefirst.story_mode_clouds.renderer.CustomCloudRenderer;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.ClassicMeshBuilder;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.MeshTypeBuilder;
import net.not_thefirst.story_mode_clouds.renderer.mesh_builders.PuffMeshBuilder;

@Environment(value=EnvType.CLIENT)
public class MeshBuilderRegistry {
    private static Map<String, MeshTypeBuilder> builders = new HashMap<String, MeshTypeBuilder>();
    private static boolean frozen = false;
    public static MeshTypeBuilder PUFF = MeshBuilderRegistry.register(CustomCloudRenderer.CloudMode.POPULATED.name(), PuffMeshBuilder::new);
    public static MeshTypeBuilder NORMAL = MeshBuilderRegistry.register(CustomCloudRenderer.CloudMode.NORMAL.name(), ClassicMeshBuilder::new);

    public static MeshTypeBuilder register(String name, Supplier<MeshTypeBuilder> builderSupplier) {
        if (frozen) {
            throw new IllegalStateException("Registry is frozen.");
        }
        if (builders.containsKey(name)) {
            throw new IllegalArgumentException("Mesh builder already registered: " + name);
        }
        MeshTypeBuilder builderInstance = builderSupplier.get();
        builders.put(name, builderInstance);
        return builderInstance;
    }

    public static MeshTypeBuilder getBuilder(String name) {
        MeshTypeBuilder builder = builders.get(name);
        if (builder == null) {
            throw new IllegalArgumentException("No builder registered for state: " + name);
        }
        return builder;
    }

    public static void freezeRegistry() {
        builders = Collections.unmodifiableMap(builders);
        frozen = true;
    }
}

