package com.provismet.dualswords;

import com.provismet.CombatPlusCore.loot.functions.EnchantRandomlyFromKeyLootFunction;
import com.provismet.dualswords.registry.DSEnchantmentComponentTypes;
import com.provismet.dualswords.registry.DSLambdas;
import com.provismet.dualswords.registry.OnStoppedUsingEffects;
import com.provismet.dualswords.util.event.EnchantmentEventHandler;
import com.provismet.dualswords.util.event.ItemEvents;
import com.provismet.dualswords.util.registry.DSRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.provismet.dualswords.config.DSSettings;
import com.provismet.dualswords.registry.DSEnchantments;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_40;
import net.minecraft.class_55;
import net.minecraft.class_77;

public class DualSwordsMain implements ModInitializer {
    public static final String MODID = "dualswords";
    public static final Logger LOGGER = LoggerFactory.getLogger("Dual Swords");
    
    public static class_2960 identifier (String path) {
        return class_2960.method_60655(MODID, path);
    }

    @Override
    public void onInitialize () {
        DSRegistries.init();
        DSEnchantmentComponentTypes.init();
        OnStoppedUsingEffects.register();
        DSLambdas.register();
        DSSettings.read();
        ItemEvents.RegisterComponentPhase();
        EnchantmentEventHandler.registerAllowEnchanting();

        LootTableEvents.MODIFY.register((key, tableBuilder, source, wrapperLookup) -> {
            if (source.isBuiltin() || DSSettings.shouldOverrideDatapacks()) {
                if (class_39.field_683.equals(key)) {
                    class_55.class_56 lootPool = class_55.method_347().method_352(class_40.method_273(1, 0.333f));
                    lootPool.method_351(class_77.method_411(class_1802.field_8529).method_438(EnchantRandomlyFromKeyLootFunction.create().option(DSEnchantments.DAISHO)));
                    tableBuilder.method_336(lootPool);
                }
                else if (class_39.field_484.equals(key)) {
                    class_55.class_56 lootPool = class_55.method_347().method_352(class_40.method_273(1, 0.2f));
                    lootPool.method_351(class_77.method_411(class_1802.field_8529).method_438(EnchantRandomlyFromKeyLootFunction.create().option(DSEnchantments.DAISHO)));
                    tableBuilder.method_336(lootPool);
                }
                else if (class_39.field_16593.equals(key)) {
                    class_55.class_56 lootPool = class_55.method_347().method_352(class_40.method_273(1, 0.15f));
                    lootPool.method_351(class_77.method_411(class_1802.field_8529).method_438(EnchantRandomlyFromKeyLootFunction.create().option(DSEnchantments.DAISHO)));
                    tableBuilder.method_336(lootPool);
                }
                else if (class_39.field_19074.equals(key)) {
                    class_55.class_56 lootPool = class_55.method_347().method_352(class_40.method_273(1, 0.05f));
                    lootPool.method_351(class_77.method_411(class_1802.field_8529).method_438(EnchantRandomlyFromKeyLootFunction.create().option(DSEnchantments.DAISHO)));
                    tableBuilder.method_336(lootPool);
                }
            }
        });
    }
}
