package com.provismet.dualswords.enchantment.effect.stopped;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import com.provismet.dualswords.enchantment.component.EnchantmentStoppedUsingEffect;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_9699;
import net.minecraft.class_9704;

public record ReverseScalingCooldownEffect (class_9704 value) implements EnchantmentStoppedUsingEffect {
    public static final MapCodec<ReverseScalingCooldownEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_9704.field_51690.fieldOf("ticks").forGetter(ReverseScalingCooldownEffect::value)).apply(instance, ReverseScalingCooldownEffect::new));

    @Override
    public void onStoppedUsing (class_3218 world, int level, class_9699 context, class_1309 user, int remainingTicks) {
        if (!(user instanceof class_1657 player)) return;

        float usage = 1f - ((float)remainingTicks / (float)context.comp_2682().method_7935(user));
        int cooldown = (int)CPCEnchantmentHelper.modifyValue(CPCEnchantmentComponentTypes.MODIFY_COOLDOWN, world, context.comp_2682(), user, (int)(this.value.method_60188(level) * usage));
        player.method_7357().method_62835(context.comp_2682(), cooldown);
    }

    @Override
    public MapCodec<ReverseScalingCooldownEffect> getCodec () {
        return CODEC;
    }
}
